/***************************************************************************
                          msnremotedesktop.h  -  description
                             -------------------
    begin                : Sat Mar 22 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MSNREMOTEDESKTOP_H
#define MSNREMOTEDESKTOP_H

#include <qwidget.h>
#include "mimeapplication.h"

/**
 * Use KDE's KRDC to use MSN's remote desktop protocol.
 *
 * @author Mike K. Bennett
 * @ingroup Applications
 */
class MsnRemoteDesktop : public MimeApplication
{
  Q_OBJECT

  public:
    // The constructor
                           MsnRemoteDesktop(const QString &contactHandle);
    // The destructor
                          ~MsnRemoteDesktop();
    // Return the application's GUID
    static QString         getAppId();

  private: // Private methods
    // Step one of a contact-started chat: the contact invites the user
    void                   contactStarted1_ContactInvitesUser(const MimeMessage& message);
    // Step two of a contact-started chat: the user accepts
    void                   contactStarted2_UserAccepts();
    // Step three of a contact-started chat: the contact confirms the accept
    void                   contactStarted3_ContactConfirmsAccept(const MimeMessage& message);
    // Start kde's remote desktop client
    void                   startRemoteClient(QString login, QString password);

  private: // Private attributes
    // The remote IP address
    QString                remoteIp_;
};

#endif
