/***************************************************************************
                          gnomemeeting.cpp  -  description
                             -------------------
    begin                : Fri Mar 21 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "gnomemeeting.h"

#include <qprocess.h>

#include <kdebug.h>
#include <klocale.h>

#include "../../kmessdebug.h"
#include "../mimemessage.h"

// The constructor
GnomeMeeting::GnomeMeeting(const QString &contactHandle)
: MimeApplication(contactHandle)
{
  setApplicationType( ChatMessage::TYPE_APPLICATION_WEBCAM );
}



// The destructor
GnomeMeeting::~GnomeMeeting()
{
#ifdef KMESSDEBUG_GNOMEMEETING
  kdDebug() << "DESTROYED GnomeMeeting" << endl;
#endif
}



// Step one of a contact-started chat: the contact invites the user
void GnomeMeeting::contactStarted1_ContactInvitesUser(const MimeMessage& /*message*/)
{
#ifdef KMESSDEBUG_GNOMEMEETING
  kdDebug() << "GnomeMeeting - contactStarted1_ContactInvitesUser" << endl;
#endif

  // Send the message to the chat window.
  offerAcceptOrReject( i18n("You are invited to start a meeting (using GnomeMeeting).") );
}



// Step two of a contact-started chat: the user accepts
void GnomeMeeting::contactStarted2_UserAccepts()
{
#ifdef KMESSDEBUG_GNOMEMEETING
  kdDebug() << "GnomeMeeting - contactStarted2_UserAccepts" << endl;
#endif

  // Create the accept message
  MimeMessage message;
  message.addField( "Invitation-Command", "ACCEPT"         );
  message.addField( "Invitation-Cookie",  getCookie()      );
  message.addField( "Launch-Application", "TRUE"           );
  message.addField( "Session-ID",         getSessionId()   );
  message.addField( "Session-Protocol",   "SM1"            );
  message.addField( "Request-Data",       "IP-Address:"    );
  message.addField( "IP-Address",         getExternalIp()  );

  sendMessage( message );
}



// Step three of a contact-started chat: the contact confirms the accept
void GnomeMeeting::contactStarted3_ContactConfirmsAccept(const MimeMessage& message)
{
#ifdef KMESSDEBUG_GNOMEMEETING
  kdDebug() << "GnomeMeeting - contactStarted3_ContactConfirmsAccept" << endl;
#endif

  // Store the data from the message
  remoteIp_ = message.getValue("IP-Address");

  // Start the application
  startMeeting( true );
}



// Return the application's GUID
QString GnomeMeeting::getAppId()
{
  return "{44BBA842-CC51-11CF-AAFA-00AA00B6015C}";
}



// Start the meeting
void GnomeMeeting::startMeeting( bool connectToRemote )
{
#ifdef KMESSDEBUG_GNOMEMEETING
  kdDebug() << "GnomeMeeting - Start the meeting." << endl;
#endif

  // Show the user that the app is starting
  showEventMessage( i18n("Starting GnomeMeeting. Connecting to %1.").arg( remoteIp_ ), ChatMessage::CONTENT_APP_INFO, ! isUserStartedApp() );

  // Start the app
  QProcess process;
  process.addArgument("gnomemeeting");
  // If the meeting should actively try to connect to the remote meeting....
  if ( connectToRemote )
  {
    // Add the "call to" arguments
    process.addArgument("-c");
    QString arg;
    arg = "callto://" + remoteIp_;
    process.addArgument( arg );
  }
  process.start();

  // Delete the application (which is now finished)
  endApplication();
}



// Step one of a user-started chat: the user invites the contact
void GnomeMeeting::userStarted1_UserInvitesContact()
{
#ifdef KMESSDEBUG_GNOMEMEETING
  kdDebug() << "GnomeMeeting - userStarted1_UserInvitesContact" << endl;
#endif
  QString     html;
  MimeMessage message;

  // Create the invitation message
  message.addField( "Application-Name",   "NetMeeting"   );
  message.addField( "Application-GUID",   getAppId()     );
  message.addField( "Session-Protocol",   "SM1"          );
  message.addField( "Invitation-Command", "INVITE"       );
  message.addField( "Invitation-Cookie",  getCookie()    );
  message.addField( "Session-ID",         getSessionId() );

  sendMessage( message );

  // Give the user the option of cancelling the invitation
  offerCancel( i18n("Inviting the contact to a meeting.") );
}



// Step two of a user-started chat: the contact accepts
void GnomeMeeting::userStarted2_ContactAccepts(const MimeMessage& message)
{
#ifdef KMESSDEBUG_GNOMEMEETING
  kdDebug() << "GnomeMeeting - userStarted2_ContactAccepts" << endl;
#endif

  // Store the data from the message
  remoteIp_ = message.getValue("IP-Address");

  // Confirm the accept-message
  MimeMessage response;
  response.addField( "Invitation-Command", "ACCEPT"         );
  response.addField( "Invitation-Cookie",  getCookie()      );
  response.addField( "Launch-Application", "TRUE"           );
  response.addField( "Session-ID",         getSessionId()   );
  response.addField( "Session-Protocol",   "SM1"            );
  response.addField( "Request-Data",       "IP-Address:"    );
  response.addField( "IP-Address",         getExternalIp()  );

  sendMessage( response );
}



// Step three of a user-started chat: the user prepares for the session
void GnomeMeeting::userStarted3_UserPrepares()
{
#ifdef KMESSDEBUG_GNOMEMEETING
  kdDebug() << "GnomeMeeting - userStarted3_UserPrepares" << endl;
#endif

  // Start the application
  startMeeting( false );
}




#include "gnomemeeting.moc"
