/***************************************************************************
                          initialview.h  -  description
                             -------------------
    begin                : Sun Jan 12 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef INITIALVIEW_H
#define INITIALVIEW_H

#include <qdict.h>
#include <qwidget.h>

#include "initialviewinterface.h"

// Forward declarations
class Account;
class KConfig;

/**
 * @brief The login widget.
 *
 * Users can login by selecting an existing account, or entering their username/password directly.
 * When the login starts, the AutoLoginView widget is displayed in the main window.
 * This class implements the events defined in the inherited user interface class.
 *
 * @author Mike K. Bennett
 * @ingroup Root
 */
class InitialView : public InitialViewInterface
{
  Q_OBJECT

  public:
    // The constructor
                         InitialView(QWidget *parent=0, const char *name=0);
    // The destructor
                        ~InitialView();
    // Add an account to the list of displayed accounts from which the user can choose
    void                 addAccount(Account *account);
    // Modify an account in the list of displayed accounts from which the user can choose
    void                 changedAccount( QString oldName, QString newName );
    // The account was deleted
    void                 deleteAccount(Account *account);

  public slots: // Public slots
    // A profile was selected from the drop-down list, or written manually.
    void                 updateView();

  private slots:
    // The "connect" button was pressed.
    void                 connectToMsn();
    // Get the currently selected handle
    QString              getSelectedHandle() const;


  private: // Private attributes
    // The list of accounts to choose from
    QDict<Account>       accounts_;  // QString keys, Account* values
    // The application's configuration file
    KConfig             *config_;
    // The default handle to display
    QString              defaultHandle_;

  signals: // Public signals
    // Connect with the given account
    void                 connectWithAccount( QString handle, QString password, bool rememberAccount, QString initialStatus );
};

#endif
