/***************************************************************************
                          addemoticondialog.h - shows a dialog to add a custom emoticon
                             -------------------
    begin                : Tue April 10 2007
    copyright            : (C) 2007 by Valerio Pilo
    email                : amroth@coldshock.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ADDEMOTICONDIALOG_H
#define ADDEMOTICONDIALOG_H

#include <kdialogbase.h>



class AddEmoticonDialogInterface;
class EmoticonTheme;



/**
 * A dialog to create a new emoticon
 *
 * There's no need to call exec() on it, just create an instance: it will popup automatically.
 * If the user accepts the changes, the new emoticon will be added to the current custom emoticons theme.
 *
 * @author Valerio Pilo <amroth@coldshock.net>
*/
class AddEmoticonDialog : public KDialogBase
{
  Q_OBJECT

  public:
    // Constructor
          AddEmoticonDialog( EmoticonTheme *theme, QWidget *parent = 0, const char *name = "AddEmoticonDialog" );
    // Destructor
         ~AddEmoticonDialog();
    // Preselects a file name and an emoticon shortcut in the dialog
    void  preSelect( QString pictureName, QString shortcut );

  private slots:
    // Shows a File Selection dialog to choose an image for the new emoticon
    void  choosePicture();
    // Controls the OK button by checking the dialog's widgets
    void  interfaceChanged();
    // Adds the new emoticon to the theme
    void  slotOk();

  private:
    // The dialog box's interface, which contains all of our widgets
    AddEmoticonDialogInterface *interface_;
    // Preselected shortcut text
    QString                     preselectedShortcut_;
    // Theme instance to which we'll add the new emoticon
    EmoticonTheme              *theme_;

  signals:
    // Signal that we've added an emoticon with this code
    void  addedEmoticon( QString shortcut );
};

#endif
