/***************************************************************************
                          emoticonbutton.cpp  -  description
                             -------------------
    begin                : Mon May 6 2002
    copyright            : (C) 2002 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "emoticonbutton.h"

#include <qcolor.h>
#include <qpalette.h>
#include <qpixmap.h>
#include <qregexp.h>
#include <qstyle.h>
#include <qtooltip.h>

#include <kdebug.h>

#include "../emoticon.h"
#include "../kmessdebug.h"

EmoticonButton::EmoticonButton(const Emoticon *emoticon, QWidget *parent, const char *name )
 : QToolButton(parent,name),
   emoticon_(emoticon)
{
  QString emoticonFile = emoticon_->getPicturePath();

  // Set the pixmap
  QPixmap emoticonPixmap(emoticonFile);
  setPixmap( emoticonPixmap );
  setFixedSize( EMOTICON_BUTTON_SIZE, EMOTICON_BUTTON_SIZE );

  // Set other properties.
  setAutoRaise(true);  // flat, only show border on mouse over
  setUsesTextLabel(false);

  // Add the emoticon tooltip
  QToolTip::add( this, emoticon_->getTooltip() );

  // Connect the button's own clicked signal to the clicked slot
  connect( this, SIGNAL(     clicked() ),
           this, SLOT  ( slotClicked() ) );
  // Connect to the emoticon to receive updates.
  connect( emoticon, SIGNAL(           changed() ),
           this,     SLOT  ( slotPixmapChanged() ) );
}



EmoticonButton::~EmoticonButton()
{
}



// The button was clicked.
void EmoticonButton::slotClicked()
{
  emit insertEmoticon( emoticon_->getShortcut() );
}


// The pixmap changed
void EmoticonButton::slotPixmapChanged()
{
kdDebug() << "EmoticonButton::slotPixmapChanged() - Emoticon has changed!" << endl;
  QPixmap emoticonPixmap( emoticon_->getPicturePath() );
  setPixmap( emoticonPixmap );
}


#include "emoticonbutton.moc"
