/*		Name:		lint.c
		Version:	0.9.17
		Date:		20/12/2003
		Expressions 
*/
#include "lint.h" 
#include "exp.h"
#include <stdio.h>
#include <glib.h>
#include <ctype.h>



Lint lint_new(long long value)
{
 Lint ret;
 int index;
 for (index=0; index<LINT_ARRAY_COUNT; index++){
    ret.data[index] = value & LINT_SINGLE_MASK;
    value = value >> LINT_SINGLE_SIZE;
    }
 return ret;
}


Lint lint_from_chararr(int count, unsigned char* ptr)
{
 Lint ret = lint_new(0);
 int index;
 for (index=0; index<count; index++)
  ret = lint_operate(ret, lint_operate(lint_new(ptr[index]), lint_new(index<<3), LINT_SL), LINT_OR);
 return ret;
}

void lint_to_chararr(int count, unsigned char* ptr, Lint number)
{
 int index;
 for (index=0; index<count; index++){
   ptr[index] = lint_to_longlong(number) & 0xFF;
   number = lint_operate(number, lint_new(8), LINT_SR);
   }
  return;
}

unsigned char* lint_to_new_chararr(int count, Lint number)
{
 unsigned char* ptr;
 ptr = g_new(unsigned char, count);
 lint_to_chararr(count, ptr, number);
  return ptr;
}


Lint lint_from_string(char* ptr, char** endptr)
{
 Lint ret = lint_new(0);
 int base;
 int digit;
 
 if ('0' == *ptr){
    if ('x' == *(ptr+1) || 'X' == *(ptr+1)) {
        ptr+=2;
        base=16;
        }
    else base = 8;
    }
 else base = 10;
 
 if (!isxdigit(*ptr)) {*endptr=NULL; return ret;}
 while (isxdigit(*ptr)){
    if (isdigit(*ptr)) digit = *ptr - '0';
    else digit = (*ptr + 9) & 0xF;                      //We could subtract 'A' and add 10 but +9 does it in one
    if (digit >= base) {*endptr=ptr; return ret;}
    
    ret = lint_operate(ret, lint_new(base), LINT_MUL);
    ret = lint_operate(ret, lint_new(digit), LINT_ADD);
    ptr++;
    }
 
 *endptr=ptr;
 return ret;
}


long long lint_to_longlong(Lint value)
{
 long long ret=0;
 int index;
 for (index=LINT_ARRAY_COUNT-1; index>=0; index--){
    ret = (ret << LINT_SINGLE_SIZE) | (value.data[index]&LINT_SINGLE_MASK);
    }
 return ret;
}


int lint_compare (Lint a, Lint b)
{
 int index;
 int ret;
 a.data[LINT_ARRAY_COUNT-1] ^= 1<<(LINT_SINGLE_SIZE-1);
 b.data[LINT_ARRAY_COUNT-1] ^= 1<<(LINT_SINGLE_SIZE-1);
 for (index=LINT_ARRAY_COUNT-1; index>=0; index--){
    ret= (int)a.data[index] - (int)b.data[index];
    if (ret) return ret;
    }
 return 0;
}

int lint_test (Lint a, Lint b)
{
 int index;
 for (index=LINT_ARRAY_COUNT-1; index>=0; index--){
    if (a.data[index] & b.data[index]) {return 1;}
    }
 return 0;
}


Lint lint_operate (Lint a, Lint b, LintSymbolType type)
{
// Dependencies:
// MUL: SL ADD
// DIV: SL SUB OR
// MOD: DIV MUL SUB


 LintDouble dbl;
 int index;
 long long ammount;
 int negative;
 Lint ret;
 switch (type) {
    case LINT_MUL:
        ret=lint_new(0);
        for (index=0; index<LINT_BIT_COUNT; index++){
            if (b.data[index/LINT_SINGLE_SIZE] & (1 << (index%LINT_SINGLE_SIZE))){
                ret = lint_operate(ret, lint_operate(a, lint_new(index), LINT_SL), LINT_ADD);
                }
            }
        return ret;
    case LINT_DIV:
        negative=0;
        if (0 > lint_compare(a,lint_new(0))) {
            negative++;
            a = lint_operate(lint_new(0), a,  LINT_SUB);
            }
        if (0 > lint_compare(b,lint_new(0))) {
            negative++;
            b = lint_operate(lint_new(0), b,  LINT_SUB);
            }

        index=5;
        ret=lint_new(0);
        while (0 <= lint_compare(a, lint_operate(b, lint_new(index), LINT_SL))) index++;
       
        while (index--){
            if(0 <= lint_compare(a, lint_operate(b, lint_new(index), LINT_SL))){
                a = lint_operate(a, lint_operate(b, lint_new(index), LINT_SL), LINT_SUB);
                ret = lint_operate(ret, lint_operate(lint_new(1), lint_new(index), LINT_SL),LINT_OR);
                }
            }
        if (negative&1) ret = lint_operate(lint_new(0), ret, LINT_SUB);
        return ret;
    case LINT_MOD:
        ret = lint_operate(a,lint_operate(lint_operate(a, b, LINT_DIV), b , LINT_MUL), LINT_SUB);
        return ret;
    case LINT_ADD:
        dbl=0;
        for (index=0; index<LINT_ARRAY_COUNT; index++){
            dbl = a.data[index] + b.data[index] + (dbl >> LINT_SINGLE_SIZE);
            ret.data[index] = dbl & LINT_SINGLE_MASK;
            }
        return ret;
    case LINT_SUB:
        dbl=0;
        for (index=0; index<LINT_ARRAY_COUNT; index++){
            dbl = a.data[index] - b.data[index] + (dbl >> LINT_SINGLE_SIZE);
            ret.data[index] = dbl & LINT_SINGLE_MASK;
            }
        return ret;
    case LINT_SL:
        ammount = lint_to_longlong(b);
        for (index=0; index<LINT_ARRAY_COUNT; index++){
            if      (index <  ammount / LINT_SINGLE_SIZE)
                    ret.data[index] = 0;
            else if (index == ammount / LINT_SINGLE_SIZE)
                    ret.data[index] = (a.data[index-ammount/LINT_SINGLE_SIZE  ]<<                 (ammount%LINT_SINGLE_SIZE)) & LINT_SINGLE_MASK;
            else    ret.data[index] = (a.data[index-ammount/LINT_SINGLE_SIZE-1]>>(LINT_SINGLE_SIZE-ammount%LINT_SINGLE_SIZE) |
                                       a.data[index-ammount/LINT_SINGLE_SIZE  ]<<                 (ammount%LINT_SINGLE_SIZE)) & LINT_SINGLE_MASK;
            }
        return ret;
    case LINT_SR:
        ammount = lint_to_longlong(b);
        for (index=0; index<LINT_ARRAY_COUNT; index++){
            if      (index >  LINT_ARRAY_COUNT-ammount / LINT_SINGLE_SIZE)
                    ret.data[index] = 0;
            else if (index == LINT_ARRAY_COUNT-ammount / LINT_SINGLE_SIZE)
                    ret.data[index] = (a.data[index+ammount/LINT_SINGLE_SIZE  ]>>                 (ammount%LINT_SINGLE_SIZE)) & LINT_SINGLE_MASK;
            else    ret.data[index] = (a.data[index+ammount/LINT_SINGLE_SIZE+1]<<(LINT_SINGLE_SIZE-ammount%LINT_SINGLE_SIZE) |
                                       a.data[index+ammount/LINT_SINGLE_SIZE  ]>>                 (ammount%LINT_SINGLE_SIZE)) & LINT_SINGLE_MASK;
            }
        return ret;
    case LINT_XOR:
        for (index=0; index<LINT_ARRAY_COUNT; index++){
            ret.data[index] = a.data[index] ^ b.data[index];
            }
        return ret;
    case LINT_AND:
        for (index=0; index<LINT_ARRAY_COUNT; index++){
            ret.data[index] = a.data[index] & b.data[index];
            }
        return ret;
    case LINT_OR:
        for (index=0; index<LINT_ARRAY_COUNT; index++){
            ret.data[index] = a.data[index] | b.data[index];
            }
        return ret;
    case LINT_BIC:
        for (index=0; index<LINT_ARRAY_COUNT; index++){
            ret.data[index] = a.data[index] & ~b.data[index];
            }
        return ret;
    default:
        return lint_new(0);
    }
}




