/*              Name:           interface.c
                Version:        0.0.12
                Date:           11/7/2001
				The interface between the GUI and the board
*/
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>        /* General Interface file*/
#include <stdlib.h>          /* The stuff that goes between */
#include <stdio.h>           /* the board and the user*/
#include <fcntl.h>
#include <sys/types.h>
#include <pwd.h>
#include <unistd.h>
#include <bfd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include "interface.h"
#include "callbacks.h"
#include "breakcalls.h"
#include "serial.h"
#include "view.h"
#include "dotparse.h"
#include "chump.h"
#include "config.h"
#include "pcpixmap.xpm"
#include "sppixmap.xpm"
#include "rapixmap.xpm"
char *dotkomodo =                   // This is very dirty
#include "dotkomodo.string"
;

#ifndef SETUP_DIR
#define SETUP_DIR g_get_home_dir()
#endif


#ifndef EMULATOR_PROG
#define EMULATOR_PROG  "jimulator"
#endif

#ifndef USE_INTERNAL
#define USE_INTERNAL 0
#endif


int special_register_count = 3;     //If you change this then also change the interface.h file 
special_reg special_registers[3] ={{ "SP", NULL, {0,0x4000,0xc000,0x4000}, sppixmap_xpm, NULL, NULL, 0, 0, 0},
                                   { "RA", NULL, {0,0x0,0x0,0x8000},       rapixmap_xpm, NULL, NULL, 0, 0, 0},
                                   { "PC", NULL, {0,0x4000,0x4000,0xFFFF}, pcpixmap_xpm, NULL, NULL, 0, 0, 0}};

uchar board_nulreg[16] = {0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0};

void board_getcpuinfo(void)  /* called from wotRu? function */
{                            /* uses board_cpu_reference_number from the board*/
 GList* toplist=Scantopnode->body.list;
 GList* cpulist;             /* scans through the init file to find the cpu */
 GList* regbankslist;
 GList* regbanklist; 
 GList* asmlist; 
 int count=0;
 char* name;
 int flag;
 int special;
 int offset;

 while (1){
  cpulist = ScanfindSymbolList    (toplist,"cpu",NULL);
  toplist = ScanfindSymbolListNext(toplist,"cpu",NULL);
  if (NULL == cpulist) {if (VERBOSE)g_print("unknown CPU!!!\n");exit(1);}
  if (ScangetNumberAdvance (&cpulist) == board_cpu_reference_number &&
      ScangetNumberAdvance (&cpulist) >= board_cpu_sub_reference_number &&
      ScangetNumberAdvance (&cpulist) <= board_cpu_sub_reference_number) break;
  }                    /* searching for the CPU info using the dotparse functions*/

 board_cpu_name = ScangetStringAdvance (&cpulist);
 if (VERBOSE)g_print("Detected        :%s\n",board_cpu_name);    /* Can be cut out or redirected to console*/
 board_memory_ptr_width = ScanfindSymbolNumber(cpulist,"memory-ptr-width",4);
 board_wordaline = ScanfindSymbol(cpulist,"wordaline",1,0);
 view_window_display_list = ScanfindSymbolString (cpulist,"window-list", NULL);
 view_window_display_list2 = ScanfindSymbolList (cpulist,"window-list2", NULL);
 if (view_window_display_list2) view_window_display_list2 = SCAN_LIST(SCAN_LIST_FIRST(view_window_display_list2));
 
 
 regbankslist = ScanfindSymbolList (cpulist,"regbanks",NULL);  /* get geeky facts about the cpu fron dotfile*/
 board_main_regbank = ScangetNumberAdvance (&regbankslist);
 board_regbanks_gran = ScanfindSymbolNumber(regbankslist,"regbank-granularity",1);
 board_num_regbanks = 1;
 regbanklist = regbankslist;
 while (NULL!=(regbanklist = ScanfindSymbolListNext (regbanklist,"regbank",NULL)))
  								 board_num_regbanks++;
 if (VERBOSE)g_print("regbanks        :%d\n",board_num_regbanks);                /* Registerbanks*/
 board_reg_banks = g_new(reg_bank,board_num_regbanks);
 for (count=0; count<board_num_regbanks;count++){
  regbanklist  = ScanfindSymbolList     (regbankslist,"regbank",NULL);
  regbankslist = ScanfindSymbolListNext (regbankslist,"regbank",NULL);
  
  board_reg_banks[count].name  =  ScangetStringAdvance (&regbanklist);
  board_reg_banks[count].number = ScangetNumberAdvance (&regbanklist);
  board_reg_banks[count].width  = ScangetNumberAdvance (&regbanklist);
  board_reg_banks[count].offset = ScangetNumberAdvance (&regbanklist);
  board_reg_banks[count].names  = ScanStrlist2Strarray               /*get register names*/
                 (ScanfindSymbolList(regbanklist,"names",NULL),
                                               board_reg_banks[count].number);
  board_reg_banks[count].values = g_new(uchar,
        MAX(1, board_reg_banks[count].width) * board_reg_banks[count].number);
  board_reg_banks[count].pointer = ScanfindSymbol(regbanklist, "pointers", 1, 0);
  
  if (board_reg_banks[count].pointer)
        for (special=0; special<special_register_count; special++)
            if (0 <= (offset = ScanfindSymbolNumber(regbanklist,special_registers[special].name, -1))){
                special_registers[special].active = 1;
                special_registers[special].value = board_reg_banks[count].values + offset * board_reg_banks[count].width;
                special_registers[special].banknumber = count;                
                special_registers[special].regnumber = offset;                
                gdk_colormap_alloc_color(gdk_colormap_get_system(),&special_registers[special].colour,0,1);
                if(special_registers[special].pixmap_data)
                        special_registers[special].pixmap = gdk_pixmap_colormap_create_from_xpm_d (NULL, gdk_colormap_get_system(), &special_registers[special].bitmap,  NULL,special_registers[special].pixmap_data);
                }
  }


 board_asm_tables=NULL;

 asmlist = ScanfindSymbolList(cpulist, "isa", NULL);
 while (asmlist){
  name = ScangetStringAdvance (&asmlist);
  toplist=Scantopnode->body.list;
  while (1){
   cpulist = ScanfindSymbolList    (toplist,"isa",NULL);
   toplist = ScanfindSymbolListNext(toplist,"isa",NULL);
   if (!cpulist) {if (VERBOSE)g_print("Could not find %s ISA description\n", name);exit(1);}
   if (!g_strcasecmp(ScangetStringAdvance(&cpulist),name)) break;

   }                    /* searching for the ISA info using the dotparse functions*/
  if (VERBOSE)g_print("ISA definition  :%s\n",name);                
  board_asm_tables = asm_define(cpulist, board_asm_tables, name);
  }
  
 
 count = board_num_features;
 for (count= 0; count< board_num_features;count++){
    toplist=Scantopnode->body.list;
    do{
        cpulist = ScanfindSymbolList    (toplist,"feature",NULL);
        toplist = ScanfindSymbolListNext(toplist,"feature",NULL);
        if (!cpulist) {
            g_print("Could not find feature desctiption refrence no:%d subrefrence no:%d\n",
                                board_features[count].reference_number,
                                board_features[count].sub_reference_number);
            break;
            }
        }while (ScangetNumberAdvance (&cpulist) != board_features[count].reference_number ||
                ScangetNumberAdvance (&cpulist) != board_features[count].sub_reference_number);
                           /* searching for the feature info using the dotparse functions*/
    if (cpulist){
        name = ScangetStringAdvance (&cpulist);
        flag=0;
        if (!g_strcasecmp("xilinx-fpga",name)) {
                flag=1;
                board_features[count].type=XILINX_FPGA;
                board_features[count].data.xilinx_fpga.filestring
                          = ScanfindSymbolString (cpulist,"XFPGA-filestring","");
                }
        if (!g_strcasecmp("console",name)) {
                flag=1;
                board_features[count].type=CONSOLE;
                }
                
        if (!flag) {if (VERBOSE)g_print("Unknown type:%s\n",name);serial_crash();}
        board_features[count].name = ScanfindSymbolString (cpulist,"name", "Add a name of the device in the .komodo file");
        board_features[count].number=count;
        }
    else{
        board_features[count].type=UNKNOWN;
        board_features[count].name = "Unknown";
        board_features[count].number=count;
        }
    
    }

 
}

int board_ping(int start)     /* Board Ping pass 1 if its the fist time and record board version*/
{                             /* Returns 0 if failed */
 int count=100;                /* check if board still there and same */
 unsigned char reply[4];
 if (VERBOSE)g_print("BigDOH!\n");
// while (gtk_events_pending())  gtk_main_iteration();          /*update display and do user stuff*/ 
 while (count--) board_sendchar(BR_NOP);  /* keep sending NOPS to clear out the fifo out */
 while (board_getchar (reply)) if (VERBOSE)g_print("Unexpected:%x\n",reply[0]);  /* flush out fifo in */
 board_there = 1;
 if (1 != board_sendchar(BR_PING))       { board_there = 0; return 0;}
 if (4 != board_getchararray(4, reply))  { board_there = 0; return 0;}
 if (reply[0] != 'O' || reply[1] != 'K') { board_there = 0; return 0;} /*make sure replay is OK*/
 if (start) board_version =  (reply[2]-0x30)*10 + reply[3]-0x30;       /*get board version*/
 if (board_version ==  (reply[2]-0x30)*10 + reply[3]-0x30) return 1;   /*check board version*/
 if (VERBOSE)g_print("Different board reconnected!");
 return 0;
}

int board_mini_ping(int start)		/* Mini Board Ping (faster) */
{                                   /* Returns 0 if failed */
 unsigned char reply[4];            /* pass 1 if its the fist time and record board version*/
 board_there = 1;                   /* dont clear out fifo*/
 if (VERBOSE)g_print("mini Ping\n");
 if (1 != board_sendchar(BR_PING))       return board_ping(start); /*on error do big ping*/
 if (4 != board_getchararray(4, reply))  return board_ping(start);
 if (reply[0] != 'O' || reply[1] != 'K') return board_ping(start);
 if (start) board_version =  (reply[2]-0x30)*10 + reply[3]-0x30;
 if (board_version ==  (reply[2]-0x30)*10 + reply[3]-0x30) return 1;
 return board_ping(start);
}

int board_micro_ping(void)         /* Micro Ping */
{                                  /* Returns 0 if failed */
 unsigned char reply[4];
 board_there = 1;
 if (1 != board_sendchar(BR_PING))       {board_mini_ping(0);return 0;} /*on error resync and reply 0 */
 if (4 != board_getchararray(4, reply))  {board_mini_ping(0);return 0;} /*used to test if any errors happened*/
 if (reply[0] != 'O' || reply[1] != 'K') {board_mini_ping(0);return 0;} /*on last transaction*/
 if (board_version ==  (reply[2]-0x30)*10 + reply[3]-0x30) return 1;
 board_mini_ping(0);
 return 0;
}


int board_enq(void)
{
  uchar c;
  unsigned int steps,steps2;
  char* string;
  board_sendchar(BR_WOT_U_DO);
  if (!board_getchar(&c)) {
    board_micro_ping();
    board_sendchar(BR_WOT_U_DO);
    if (!board_getchar(&c)) return 0x30;
    }
  if (4 != board_getb32(&steps)) return 0x30;
  if (4 != board_getb32(&steps2)) return 0x30;
  if (steps)    string = g_strdup_printf("  Steps left:%u",steps);
  else          string = g_strdup_printf("  Total steps:%u",steps2);
  gtk_label_set_text (GTK_LABEL(view_steplabel),string);
  g_free(string);
  
  switch (c>>6){
    case 0:
        // Board reset!!!
        gtk_label_set_text (GTK_LABEL(view_enqlabel),"Reset");
        callback_global_refresh(); /* refresh all */
        breakpoint_refresh (0);
        breakpoint_refresh (1);
        return 0x30;
    case 1:
        // Stopped
        gtk_label_set_text (GTK_LABEL(view_enqlabel),"Stopped");
        switch (c&7){
            case 0:
                gtk_label_set_text (GTK_LABEL(view_enqlabel),"Stopped");
                break;
            case 1:
                gtk_label_set_text (GTK_LABEL(view_enqlabel),"Breakpoint");
                break;
            case 2:
                gtk_label_set_text (GTK_LABEL(view_enqlabel),"Watchpoint");
                break;
            case 3:
                gtk_label_set_text (GTK_LABEL(view_enqlabel),"Page Fault");
                break;
            case 4:
                gtk_label_set_text (GTK_LABEL(view_enqlabel),"Stop");
                break;
            }
        return c;
    case 2:
        // Running
            gtk_label_set_text (GTK_LABEL(view_enqlabel),"Running");
            return c;
    case 3:
        // Error
        string = g_new(char, (c&0x3f)+1);
        string[c&0x3f]='\0';
        if ((c&0x3f) == board_getchararray (c&0x3f, string))
                gtk_label_set_text (GTK_LABEL(view_enqlabel),string);
        g_free(string);
        return c;
    }
  return 0x30;
}

int board_wotru(void)      /* Get Board Info */
{                          /* 0 if failed    */
 int lengthofmessage;      /* Get board info */
 uchar *message;   /* Called at the start to get board info */
 int i=0;
 int count;

 if (!board_there) return 0;
 if (1 != board_sendchar(BR_WOT_R_U))      { board_there = 0; return 0;}
 if (2 != board_getb16(&lengthofmessage))  { board_there = 0; return 0;}
 message = g_new(uchar, lengthofmessage);
 if (lengthofmessage != board_getchararray(lengthofmessage, message))
                          { g_free(message); board_there = 0; return 0;}
 board_cpu_reference_number =      message[i++];
 board_cpu_sub_reference_number =  message[i++];  /* All info collected is stored in the public vareables */
 board_cpu_sub_reference_number += message[i++]<<8;
 board_num_features = message[i++];
 board_features = g_new(feature, board_num_features);
 for (count= 0; count< board_num_features;count++) {
   board_features[count].reference_number      = message[i++];
   board_features[count].sub_reference_number  = message[i++];
   board_features[count].sub_reference_number += message[i++]<<8;
   }
 
 board_getcpuinfo();
  
 board_num_mem_segments = message[i++];
 board_mem_segments = g_new (memory_segment, board_num_mem_segments);
 for (count= 0; count< board_num_mem_segments;count++) {
   board_mem_segments[count].start = 
		   g_memdup(&message[i],board_memory_ptr_width * sizeof(uchar));
   i+=board_memory_ptr_width;
   board_mem_segments[count].length =
		   g_memdup(&message[i],board_memory_ptr_width * sizeof(uchar));
   i+=board_memory_ptr_width;
   }
  
 g_free(message);
 return 1;
}

int board_get_regbank (int regbanknumber)  /*update registerbank*/
{
 unsigned char* message;                   /* register bank values are kept in the regbank struct*/
 int counter=0;
 int length_message;
 int gran;
 if (!board_there) return 0;
 if (1 != board_sendchar(BR_GET_REG))      { board_there = 0; return 0;}
 if (board_reg_banks[regbanknumber].width)  {       /*if regbank is not a bit field*/
  length_message = board_reg_banks[regbanknumber].width *
                  board_reg_banks[regbanknumber].number;
  if (4 != board_sendb32(board_reg_banks[regbanknumber].offset))
                                            { board_there = 0; return 0;}
  if (2 != board_sendb16(board_reg_banks[regbanknumber].number))
                                            { board_there = 0; return 0;}
                
  if (length_message != board_getchararray(length_message,
                           board_reg_banks[regbanknumber].values))
                                            { board_there = 0; return 0;}
  }
 else {                                 /* Get regbank if its a bit field*/
  gran = board_regbanks_gran<<3;                         /* dont go here unless youre mad*/
  length_message = (((board_reg_banks[regbanknumber].number +
                      board_reg_banks[regbanknumber].offset - 1) / gran) -
                     (board_reg_banks[regbanknumber].offset      / gran) + 1);
  if (4 != board_sendb32(board_reg_banks[regbanknumber].offset/gran))
                                            { board_there = 0; return 0;}
  if (2 != board_sendb16(length_message))
                                            { board_there = 0; return 0;}
  
/*
 *   if (VERBOSE)g_print("getting registerbank %d at offset %x size %d\n" ,
 *                 regbanknumber,
 *                 board_reg_banks[regbanknumber].offset>>3,
 *                 board_reg_banks[regbanknumber].number);
 */
                
  length_message = length_message * board_regbanks_gran;
  message = g_new (unsigned char,length_message);
  if (length_message != board_getchararray(length_message,message))
                         { g_free (message); board_there = 0; return 0;}
  length_message = board_reg_banks[regbanknumber].number;
  gran = board_reg_banks[regbanknumber].offset % gran;
  while (counter<board_reg_banks[regbanknumber].number){
   board_reg_banks[regbanknumber].values[counter] =
             message[(counter+gran)>>3]>>((counter+gran)&7)&1;
   counter++;
   }
     g_free(message);
  }

 return 1;
}

int board_set_register(int regbanknumber, int registernumber,  /* set register */
                                         unsigned char *value) /* BTW values are passed around */
{                                                              /* as pointers to an array of unsigned chars*/
 int count;
 uchar *cpuregvalue;
 if (!board_there) return 0;
 if (board_reg_banks[regbanknumber].width){
  if (1 != board_sendchar(BR_SET_REG))     { board_there = 0; return 0;}
  count = board_reg_banks[regbanknumber].width; 
  if (4 != board_sendb32(board_reg_banks[regbanknumber].offset + registernumber))
                                           { board_there = 0; return 0;}
  if (2 != board_sendb16(1))               { board_there = 0; return 0;}
  if (board_reg_banks[regbanknumber].width != board_sendchararray(count,value))
                                           { board_there = 0; return 0;}
  }
 else {                                                         /* if register is a bit field */
  count=(board_reg_banks[regbanknumber].offset + registernumber);
  if (1 != board_sendchar(BR_GET_REG))     { board_there = 0; return 0;}
  if (4 != board_sendb32((count>>3) / board_regbanks_gran))
                                           { board_there = 0; return 0;}
  if (2 != board_sendb16(1))
                                           { board_there = 0; return 0;}  /*all complex stuff */

  cpuregvalue = g_new(uchar,board_regbanks_gran);                         /* dont go here unless youre mad*/
  if (board_regbanks_gran != board_getchararray(board_regbanks_gran,cpuregvalue))
                       {g_free(cpuregvalue); board_there = 0; return 0;}
  if (*value) cpuregvalue[(count>>3)%board_regbanks_gran] |=   1 << (count&7);
  else        cpuregvalue[(count>>3)%board_regbanks_gran] &= ~(1 << (count&7));
  
  if (1 != board_sendchar(BR_SET_REG))
                       {g_free(cpuregvalue); board_there = 0; return 0;}
  if (4 != board_sendb32((count>>3) / board_regbanks_gran))
                       {g_free(cpuregvalue); board_there = 0; return 0;}
  if (2 != board_sendb16(1))
                       {g_free(cpuregvalue); board_there = 0; return 0;}
  if (board_regbanks_gran != board_sendchararray(board_regbanks_gran,cpuregvalue))
                       {g_free(cpuregvalue); board_there = 0; return 0;}
	
  }
 return 1;
}


int board_get_memory (int count, unsigned char* address, unsigned char* dest, int size) /*get memory*/
{                    /* number of bytes    address pointer    where to store*/
 char c=BR_GET_MEM;
 int bytecount=count*size;
 while (!(size&1)) {size=size>>1; c++;}
 if (!board_there) return 0;
 if (1 != board_sendchar(c))      { board_there = 0; return 0;}
 if (board_memory_ptr_width != board_sendchararray
                              (board_memory_ptr_width, address))
                                           { board_there = 0; return 0;}
 if (2 != board_sendb16(count))            { board_there = 0; return 0;}
 if (bytecount != board_getchararray(bytecount,dest))
                                           { board_there = 0; return 0;}
 return 1;
}

int board_set_memory (int count, unsigned char* address, unsigned char* sourc, int size)
{                    /* number of bytes    address pointer    where data to send*/
 char c=BR_SET_MEM;
 int bytecount=count*size;
 while (!(size&1)) {size=size>>1; c++;}
 if (!board_there) return 0;
 
 if (1 != board_sendchar(c))      { board_there = 0; return 0;}
 if (board_memory_ptr_width != board_sendchararray(board_memory_ptr_width,
                              address))    { board_there = 0; return 0;}
 if (2 != board_sendb16(count))            { board_there = 0; return 0;}
 if (bytecount != board_sendchararray(bytecount,sourc))
                                           { board_there = 0; return 0;}
 return 1;
}

void dead_child(int signo)
{
 g_print("Child process died\n");
 exit(1);
}

int main(int argc, char *argv[]) /* main function*/
{
 GtkWidget *view_splashwindow;
 VERBOSE=VERBOSE_D;
 rcfile = g_strconcat (SETUP_DIR,"/.komodo",NULL);
 emulator_prog = EMULATOR_PROG;
 use_internal = USE_INTERNAL;
 pipe_name_in = "emul_in";
 pipe_name_out = "emul_out";

 commandline(argc, argv);
 gtk_init(&argc, &argv);			 /* init GTK (user interface)*/
 view_splashwindow = create_splashwindow();
 setup();
 
// gtk_widget_hide(view_splashwindow);
// while (gtk_events_pending())  gtk_main_iteration();

 gtk_widget_destroy(view_splashwindow);
 
 gtk_main ();/* give control to GTK*/
 return 0;
}

void commandline(int argc, char *argv[])
{
 int count=1;
 int comp;              // 
 FILE* fd;
 int create=0;
 char* gtkrc[] = {NULL,NULL} ;
 char* commandstrings[]={"--help", "-h", "-?", "-e", "-s", "-c", "-k", "-i", "-t", "-v", "-q","-f", "-d", "-p", NULL};
            //             0         1     2     3     4     5     6     7     8     9    10   11    12    13   14
 
 board_type = EMULATOR;
 portname = PORTNAME;
 comms_file = NULL;
 
 while (argv[count]) {
   if ('-' != *argv[count]) {g_print("Unknown option %s\n",argv[count]);exit(1);}
   comp=0;
   while (g_strcasecmp(commandstrings[comp],argv[count]))
        if (!commandstrings[++comp]) {g_print("Unknown option  %s\n",argv[count]);exit(1);}

   switch (comp) {
    case 0:
    case 1:
    case 2:         //help
        g_print("\n " PACKAGE " Version " VERSION " (" DATE ")\n");
        g_print(" Copyright " YEAR " University of Manchester \n");
        g_print(" Authors:Charlie Brej & Jim Garside\n");
        g_print(" Bug reports and feature requests: komodo@cs.man.ac.uk\n");
        g_print(" Website: http://www.cs.man.ac.uk/teaching/electronics/komodo\n");
        g_print("\n");
        g_print(" Usage: kmd [options]\n");
        g_print("\n");
        g_print("   --help\n");
        g_print("   -h\n");
        g_print("   -?              display this help message\n");
        g_print("   -e [emulator]   run on an emulator program Default: %s\n",EMULATOR_PROG);
        g_print("   -s [port]       run through serial port Default:" PORTNAME "\n");
        g_print("   -p [rd] [wr]    run with emulator through pipes\n");
        g_print("   -f              run with a fake backend\n");
        g_print("   -c              create the default .komodo file in %s\n", SETUP_DIR );
        g_print("   -k komodofile   use specific .komodo file Default: %s/.komodo\n", SETUP_DIR );
        g_print("   -i              use standard .komodo file compiled into program\n");
        g_print("   -t gtkrc        change GTK+ theme by specifying a different gtkrc file\n");
        g_print("   -v              be verbose\n");
        g_print("   -d dumpfile     dump all communication to file\n");
        g_print("   -q              be quiet\n");
        exit(0);
    case 3:         //emulator -e
        board_type = EMULATOR;
        if (argv[count+1]) if ('-' != *argv[count+1]) emulator_prog = argv[++count];
        break;
    case 4:         //serial -s
        board_type = SERIAL;
        if (argv[count+1]) if ('-' != *argv[count+1]) portname = argv[++count];
        break;
    case 5:         //Create .komodo file -c
        create = 1;
        break;
    case 6:         //dotkomodo -k
        use_internal = 0;
        if (argv[count+1]) if ('-' != *argv[count+1]) rcfile = argv[++count];
        break;
    
    case 7:         //dotkomodo -i
        use_internal = 1;
        break;
    
    case 8:         //Theme -t
        if (argv[count+1]) if ('-' != *argv[count+1]){
                                gtkrc[0]=argv[++count];
                                gtk_rc_set_default_files(gtkrc);
                                }
        break;
    case 9:         //Verbose -v
        VERBOSE=1;
        break;
        
    case 10:       //Quiet -q
        VERBOSE=0;
        break;

    case 11:       //Fake -f
        board_type = FAKE;
        break;
        
    case 12:       //Dump -d
        if (argv[count+1]){
            if ('-' != *argv[count+1]) comms_file = fopen(argv[++count], "w");
            else comms_file = fopen("KMD_COMMS_DUMP", "w");
            }
        if (!comms_file) {g_print("cant open .komodo file\n"); exit(1);}

        break;

    case 13:         //pipe -p
        board_type = PIPE;
        if (argv[count+1]) if ('-' != *argv[count+1]) pipe_name_in = argv[++count];
        if (argv[count+1]) if ('-' != *argv[count+1]) pipe_name_out = argv[++count];
        break;

        
    default:
        g_print("Command paramiter Error!");
        exit(1);
    }
   count++;
   }

  if (create){
        fd = fopen (rcfile,"w");
        if (!fd) {g_print("cant open .komodo file\n"); exit(1);}
        fprintf(fd, "%s", dotkomodo);
        fclose(fd);
        g_print("Done creating %s\n", rcfile);
        exit(0);
        }
  
  
}


void setup() /* setup function*/
{
 GScanner *scanner;
 int temp;
 struct sigaction cleanup;
 GtkStyle* default_style;
 int regbank;
 PtrSCANNode config_topnode;

 bfd_init ();            			/* init BFD (exectuable file loader) */


 symbol_table=NULL;
 
 
 if (use_internal) 
     scanner = ScanOpenSCANString (dotkomodo); 	/* use internal file */
 else               scanner = ScanOpenSCANFile   (rcfile); 	/* open .komodo */
 if(!scanner) {
        g_print("Cannot find setup file!\nIf you would like to create one then start komodo with -c flag\nOr use the default internal one with -i\n");
        exit(1);
        }
 Scantopnode = ScanParseSCANNode (scanner, FALSE); /* Scan .komodo file*/
 ScanCloseSCANFile (scanner);
 
 
 
 config_file = g_strconcat (SETUP_DIR,"/.kmd_config",NULL);
 scanner = ScanOpenSCANFile   (config_file);         /* open .kmd_config */
 if(!scanner) {
        config_toplist = NULL;
        }
 else{
        config_topnode = ScanParseSCANNode (scanner, FALSE); /* Scan .kmd_config file*/
        ScanCloseSCANFile (scanner);
        if (SCAN_IS_LIST(config_topnode)) {
            config_toplist = SCAN_LIST(config_topnode);
            SCAN_LIST(config_topnode)=NULL;
            ScanDeleteSCANNode(config_topnode);
            }
        else config_toplist = NULL;
        }
 



 if (Scantopnode) {if (VERBOSE)g_print(".komodo init     :PASSED\n");}
 else { if (VERBOSE) g_print(".komodo init     :FAILED\n.komodo file error\n");return;} /*Panic*/

 default_style = gtk_widget_get_default_style();
 fixed_style   = gtk_style_copy(default_style);
 
#ifdef GTK2
fixed_style->font_desc = pango_font_description_from_string("lucidatypewriter 9");
#endif

#ifndef GTK2
// fixed_font = gdk_font_load("-*-lucidatypewriter-medium-*-*-*-*-120-*-*-*-*-*"); /* get fixed font*/
 if (NULL == fixed_font) fixed_font = gdk_font_load("fixed"); /* if no good font get pants fixed font*/
 fixed_style->font = fixed_font;                               /* create style with new font*/
#endif

 pipe(compile_communication);
 gdk_input_add  (compile_communication[0],GDK_INPUT_READ, (GdkInputFunction) callback_console_update , NULL);




 
 if (SERIAL == board_type){
    temp = serial_setup(1);
    read_pipe = serial_FD;
    write_pipe = serial_FD;
    if (VERBOSE) g_print("Serial Setup    :%d\n",temp);      /*setup serial port */
    if (!temp) exit(1);
    }

 if (EMULATOR == board_type){
    pipe(board_emulation_communication_from);
    read_pipe = board_emulation_communication_from[0];
    pipe(board_emulation_communication_to);
    write_pipe = board_emulation_communication_to[1];
    board_emulation_pid = fork();
    if (!board_emulation_pid) {
            int error;
            nice(10);
            close(1);
            dup2(board_emulation_communication_from[1],1);
            close(0);
            dup2(board_emulation_communication_to[0],0);
            close(2);
            dup2(compile_communication[1],2);

            
            error = execlp(emulator_prog, emulator_prog,NULL);
//            fprintf(stderr, "DEAD:%d/n",error);
//            system(emulator_prog);
//            fprintf(stderr, "DEAD/n");
//            perror("something");
            exit(0);
            }
    if (VERBOSE) g_print("Emulating with : %s\n",emulator_prog);
    }
  
 if (PIPE == board_type){

    read_pipe = open (pipe_name_in, O_RDONLY);

    write_pipe = open (pipe_name_out, O_WRONLY);

    if (VERBOSE) g_print("Piping through %s and %s\n",pipe_name_in,pipe_name_out);
    }



 cleanup.sa_handler = (void (*)()) callback_crash;
 sigemptyset(&cleanup.sa_mask);
 cleanup.sa_flags = 0;

 sigaction(SIGINT,  &cleanup, NULL);
 sigaction(SIGHUP,  &cleanup, NULL);
 sigaction(SIGTERM, &cleanup, NULL);
 sigaction(SIGSEGV, &cleanup, NULL);
 sigaction(SIGBUS,  &cleanup, NULL);
  
    

 
 temp = board_mini_ping(1);
 if (VERBOSE) g_print("ping            :%d\n",temp);  /*establish contact with board */
 if (!temp) exit(1);
 if (VERBOSE) g_print("board version   :%d\n",board_version);
 temp = board_wotru();
 if (VERBOSE) g_print("wotRu           :%d\n",temp);       /* Ask board what it is*/
 if (!temp) exit(1);


 for (regbank=0;regbank<board_num_regbanks;regbank++)
    if (!board_get_regbank(regbank))
        if (!board_mini_ping(0) || !board_get_regbank(regbank)) return;






 view_create_mainwindow();                             /* Create window */
 if (view_window_display_list) gtk_container_add (GTK_CONTAINER(view_maincontainer),view_parse_list()); /* Create all contents windows*/
 else gtk_container_add (GTK_CONTAINER(view_maincontainer),view_parse_list2(view_window_display_list2)); /* Create all contents windows*/
 callback_global_refresh();
 g_timeout_add(REFRESH_PERIOD, callback_updateall, NULL);
 board_enq();
 return;
}
