/*              Name:           asmload.c
                Version:        0.9.15
                Date:           31/8/2003
				Loading asm files and compiling them on the fly.
*/
#include <stdio.h>
#include <glib.h>
#include "chump.h"
#include "misc.h"
#include "asmload.h"
#include "progload.h"
#include "callbacks.h"
#include "interface.h"
#include "lint.h"




void asmload_load (char* filename)
{
 source_file* new_source_file;
 FILE *Fhandle;
 GList* lines;
 char line[1000];    // I cant think why anyone would want lines longer than 1000 chars
                     // if someone does then this will go wrong
 AsmStatus stat = asm_default_status;
 GList* asmlist;
 Asm* asmed;
 long long address=0;
 int temp;
 uchar* hex;
 uchar* address_chararr;
 int line_no=1;
 int pass;
 int flags[] = {ASMFLAG_IGNORESYMBOLS, 0};

    {
    GList* temp = progload_source_files;
    
    while (temp) {
        g_free(((source_file*)temp->data)->filename);
        g_list_free_contents(((source_file*)temp->data)->lines);
        g_list_free(((source_file*)temp->data)->lines);
        g_free( (source_file*)temp->data);
        temp = temp->next;
        }
    g_list_free(progload_source_files);

    g_list_free_contents(address_line_list);
    g_list_free(address_line_list);

    progload_source_files =NULL;    
    address_line_list = NULL;
    old_pcline=NULL;
    old_raline=NULL;
    }
 if (symbol_table)    {
        symbol_free_table (symbol_table);
        symbol_table=NULL;
        }
 new_source_file = g_new(source_file,1);
 progload_source_files = g_list_append(NULL, new_source_file);
 new_source_file->filename = g_strdup(filename);
 new_source_file->error=NULL;
 new_source_file->lines=NULL;
 Fhandle = fopen (filename, "r");

 if (!Fhandle) {new_source_file->error="Can not open file"; return;}
 
 while (fgets (line, sizeof line, Fhandle)){
     new_source_file->lines = g_list_append(new_source_file->lines, g_strdup(line)); //Possibly slow
     }
 fclose (Fhandle);



 for (pass=0; pass<2; pass++){

  address=0;
  lines=new_source_file->lines;
  stat.flags = flags[pass];
  
  while (lines){
    GList* symbol_list;
    Symbol* symbol;
    stat.symbol_table=symbol_table;
    stat.address=address;
    asmlist = asm_assemble((char*)lines->data, view_load_isa, stat, 1);
    
    if (!asmlist) {
        g_print("ERROR on in pass %d on line:\n%s\n",pass, (char*)lines->data);
        return;
        }

    asmed = (Asm*) (asmlist->data);
    symbol_list = asm_print_symbols(asmed->binary, NULL);

    while(symbol_list) {
        symbol = symbol_findstring(symbol_table, (char*)symbol_list->data);
        if (symbol) {
            symbol->value = lint_new(address);
            }
        else {
            symbol = g_new(Symbol, 1);
            symbol->flags = 2;
            symbol->name = symbol_list->data;
            symbol->value = lint_new(address);
            symbol_table = g_list_append(symbol_table,symbol);
//            g_print("%x:\"%s\"\n", address, symbol->name);
            }
        symbol_list = g_list_remove(symbol_list,symbol_list->data);
        }
    
    
    temp = asm_sbprint(asmed->binary, &hex);
    g_free(hex);
    address += temp;

    while(asmlist) {
        asm_freestringlist(((Asm*)asmlist->data)->binary);
        g_free(asmlist->data);
        asmlist = g_list_remove(asmlist,asmlist->data);
        }

    lines=lines->next;
    }
  }

 address=0;
 lines=new_source_file->lines;

 while (lines){
    stat.address=address;
    stat.symbol_table=symbol_table;
    asmlist = asm_assemble((char*)lines->data, view_load_isa, stat, 1);
    
    asmed = (Asm*) (asmlist->data);
    temp = asm_sbprint(asmed->binary, &hex);
    if (asmlist->next) if (VERBOSE) g_print("Multiple possible assemblies, size:%d",g_list_length(asmlist));
    
    while(asmlist) {
        asm_freestringlist(((Asm*)asmlist->data)->binary);
        g_free(asmlist->data);
        asmlist = g_list_remove(asmlist,asmlist->data);
        }
    address_chararr = view_int2chararr(board_memory_ptr_width, address);
    board_set_memory(temp,address_chararr,hex,1);      /* set memory*/
    
    if (temp){
            address_line* new_line = g_new(address_line,1);
            new_line->address = address;
            new_line->line = line_no;
            new_line->file = new_source_file;
            address_line_list = g_list_insert_sorted (address_line_list,new_line,progload_address_line_compare);
//        g_print("%x, %s, %s, %d \n", new_line->address, filename, functionname, line);
//        g_print("%s\n",(char*)g_list_nth_data(file->lines, line));
            }
    g_free(address_chararr);
    g_free(hex);
    address += temp;
    line_no++;
    lines=lines->next;
    }
 progload_update();
}
