/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@bauniga.baita                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <kapplication.h>
#include <kconfig.h>
#include "globals.h"
#include <qdir.h>
#include <kmessagebox.h>
#include <klocale.h>
// #include <sys/stat.h> 
 
Configuration & Config( )
{
	static Configuration conf;
	return conf;
}

Configuration::Configuration( )
{
	read();
	
}

void Configuration::read( )
{
	KConfig *conf=kapp->config();
	
	conf->setGroup("General");
	configured=conf->readBoolEntry("configured", false);
	dbDir=conf->readPathEntry("dbdir", QDir::homeDirPath() + "/klibido/db");
	decodeDir=conf->readPathEntry("decodedir", QDir::homeDirPath() + "/klibido/decoded");
	tmpDir=conf->readPathEntry("tmpDir", QDir::homeDirPath() + "/klibido/tmp");
	
	conf->setGroup("Decode");
	overwriteExisting=conf->readBoolEntry("overwriteExisting", false);
	deleteFailed=conf->readBoolEntry("deleteFailed", false);
	useUU= conf->readBoolEntry("useuu", true);
	
	conf->setGroup("View");
	activateTab=conf->readBoolEntry("activateTab", true);
	singleViewTab=conf->readBoolEntry("singleView", false);
	showStatusBar=conf->readBoolEntry("showStatusBar", true);
	dViewed=conf->readNumEntry("deleteViewed", Configuration::Ask);
	
	
	
	conf->setGroup("HeaderList");
	showFrom = conf->readBoolEntry("showfrom", false);
	showDetails = conf->readBoolEntry("showdetails", true);
	showDate = conf->readBoolEntry("showdate", true);
	allowExpansion = conf->readBoolEntry("allowexpansion", true);
	markOpt = conf->readNumEntry("headerclose", Configuration::Ask);
	
	alwaysDoubleClick = conf->readBoolEntry("alwaysdoubleclick", false);
	rememberSort = conf->readBoolEntry("remembersort", false);
	rememberOrder = conf->readBoolEntry("rememberorder", false);
	rememberWidth = conf->readBoolEntry("rememberwidth", false);
	
	keepListSettings = conf->readBoolEntry("keeplistsettings", false);
	
	
		
	

}

void Configuration::write( ) const
{
	KConfig *conf=kapp->config();
	
	conf->setGroup("General");
	conf->writeEntry("configured", configured);
	conf->writePathEntry("dbdir", dbDir);
	conf->writePathEntry("decodedir", decodeDir);
	conf->writePathEntry("tmpDir", tmpDir);
	
	conf->setGroup("Decode");
	conf->writeEntry("overwriteExisting", overwriteExisting);
	conf->writeEntry("deleteFailed", deleteFailed);
	conf->writeEntry("useuu", useUU);
	
	conf->setGroup("View");
	conf->writeEntry("activateTab", activateTab);
	conf->writeEntry("singleView", singleViewTab);
	conf->writeEntry("showStatusBar", showStatusBar);
	conf->writeEntry("deleteViewed", dViewed);

	
	
	conf->setGroup("HeaderList");
	conf->writeEntry("showfrom", showFrom);
	conf->writeEntry("showdetails", showDetails);
	conf->writeEntry("showdate", showDate);
	conf->writeEntry("allowexpansion", allowExpansion);
	conf->writeEntry("remembersort", rememberSort);
	conf->writeEntry("rememberorder", rememberOrder);
	conf->writeEntry("rememberwidth", rememberWidth);
	
	conf->writeEntry("alwaysdoubleclick", alwaysDoubleClick);
	conf->writeEntry("keeplistsettings", keepListSettings);
	conf->writeEntry("headerclose", markOpt);


}

bool mkDeepDir( QString dirName )
{
	QDir d;
	
	QString newDir=dirName.mid(0, dirName.findRev('/'));
// 	qDebug("Dir: %s", newDir.latin1());
	if (d.exists(newDir)) 
		return true;
	if (mkDeepDir(newDir)) {
// 		qDebug("create dir: %s", (const char *) newDir);
		if (d.mkdir(newDir))
			return true;
		else return false;
	} else return false;
	
}

bool dirCreated ()
{

  QDir dir;
  if ( !dir.cd(Config().dbDir))
      return false;
  if ( !dir.cd(Config().tmpDir))
      return false;
  if ( !dir.cd(Config().decodeDir))
      return false;
  /*struct stat statBuffer;
  if (stat(Config().dbDir()., &statBuffer) != 0)
     return false;
  if (stat(Config().tmpDir(), &statBuffer) != 0)
     return false;
  if (stat(Config().decodeDir(), &statBuffer) != 0)
     return false;*/
  return true;
}

bool checkAndCreateDir( QString dirName )
{
	QString dir=QDir::cleanDirPath(dirName);
	dir+='/';
	if (QDir::isRelativePath(dir) ) {
		KMessageBox::error(0, i18n("Please enter only absolute paths"), i18n("Error"));
		return false;
	}
	if (!mkDeepDir(dir))
		return false;
	else { 
		//check if the dir is writable
		QFileInfo fi(dir);
		if (fi.isWritable())
			return true;
		else return false;
		
		
	}
}
NntpHost * loadHost( char *p, int version )
{
	char *i=&p[0];
	NntpHost *nh=new NntpHost;
	i=retrieve(i,nh->hostName);
	i=retrieve(i,nh->name);
	i=retrieve(i,nh->userName);
	i=retrieve(i,nh->pass);
	int szInt=sizeof(int);
	
	memcpy(&(nh->timeout),i,szInt);
	i+=szInt;
	memcpy(&(nh->id),i,szInt);
	i+=szInt;
	memcpy(&(nh->priority), i, szInt);
	i+=szInt;
	memcpy(&(nh->threadTimeout),i,szInt);
	i+=szInt;
	if (version >= 1) {
		memcpy(&(nh->retries), i, szInt);
		i+=szInt;
	}
	
	memcpy(&(nh->maxThreads),i,szInt);
	i+=szInt;
	memcpy(&(nh->port), i, szInt);
	nh->workingThreads=0;
	nh->speed=0;
	nh->item=0;
	nh->size=0;
	return nh;
}

char* retrieve(char* i,QString &s) {


	int strlen;
// 	int ssize=sizeof(strlen);

	char *temp;
	memcpy(&strlen, i, szInt);

	i+=szInt;
	temp=new char[strlen+1];
	memcpy(temp, i, strlen);
	temp[strlen]='\0';
	s=temp;
	delete [] temp;
	i+=strlen;
	return i;



}

int size( NntpHost *nh )
{
	return nh->hostName.length()+nh->name.length()+nh->pass.length()+nh->userName.length()+11*sizeof(int);
}

char * saveHost( NntpHost *nh )
{
	char *p=new char[size(nh)];
	char *i=&p[0];
	i=insert(nh->hostName, i);
	i=insert(nh->name,i);
	i=insert(nh->userName,i);
	i=insert(nh->pass,i);
	int szInt=sizeof(int);
	
	memcpy(i,&(nh->timeout),szInt);
	i+=szInt;
	memcpy(i,&(nh->id),szInt);
	i+=szInt;
	memcpy(i,&(nh->priority),szInt);
	i+=szInt;
	memcpy(i,&(nh->threadTimeout),szInt);
	i+=szInt;
	memcpy(i, &(nh->retries), szInt);
	i+=szInt;
	memcpy(i,&(nh->maxThreads),szInt);
	i+=szInt;
	memcpy(i,&(nh->port), szInt);
	
	
	
	
	return p;
	
	
	
}

char* insert(QString s, char* p) {
	int strlen=s.length();
// 	int suint = sizeof(strlen);
	memcpy(p, &strlen, szInt);

	p+=szInt;
	memcpy(p, (const char *)s, strlen);
	p+=strlen;
	return p;



}


