/*
 * This file is a part of KleanSweep.
 *
 * Copyright (C) 2005 Pawel Stolowski <pawel.stolowski@wp.pl>
 *
 * KleanSweep is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#ifndef __SUMMARYLABEL_H
#define __SUMMARYLABEL_H

/*! \file summarylabel.h */

#include <qhbox.h>
#include <qgrid.h>

class QLabel;

class SummaryLabel: public QHBox
{
	Q_OBJECT
		
	protected:
		int totsize;
		int totitems;
		int selitems;
		int selsize;

		QLabel *l_totsize;
		QLabel *l_totitems;
		QLabel *l_selsize;
		QLabel *l_selitems;

		static QString formatSize(int n);

	public slots:
		void setTotalItems(int n);
		void setSelectedItems(int n);
		void setSelectedSize(int size);
		void updateSelectedInfo(int d, unsigned int size);
		void setTotalSize(int size);
		void setTotals(int n, unsigned int size);
		void reset();
			
	public:
		SummaryLabel(QWidget *parent);
		virtual ~SummaryLabel();
};

#endif

