/*
 * This file is a part of KleanSweep.
 *
 * Copyright (C) 2005 Pawel Stolowski <pawel.stolowski@wp.pl>
 *
 * KleanSweep is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#ifndef __CONFIGDLG_H
#define __CONFIGDLG_H

/*! \file configdlg.h */

#include <kdialogbase.h>

class DirListWidget;
class QCheckBox;
class QSpinBox;
class QRadioButton;

class KleanSweepConfigDialog: public KDialogBase
{
	Q_OBJECT

	protected:
		DirListWidget *globalexcl;
		DirListWidget *orphincl;
		DirListWidget *orphexcl;
		QCheckBox *showprogress;
		QCheckBox *optimizesearch;
		QCheckBox *showscore;
		QRadioButton *rb_deb;
		QRadioButton *rb_rpm;
		QRadioButton *rb_other;
		//QSpinBox *oldfilesage;
		
		void setupGeneralPage();
		void setupOrphansPage();
	
	protected slots:
		virtual void slotApply();

	public:
		KleanSweepConfigDialog(QWidget *parent);
		virtual ~KleanSweepConfigDialog();
};

#endif

