/*
 *  Klavier : Virtual keyboard for K Destop Environement
 *
 *  This program (klavier) is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 *  This program (klavier) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public
 * License along with this program (klavier); if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307 USA. 
 *
 * Author : Sebastien HUSS <sebastien.huss@laposte.net>
 *
 */
#include "keyboardmodifier.h"

KeyboardModifier::KeyboardModifier(sendKey * wire, const KeyCode mycode, QWidget * parent, const char * name)
	: PushKey(wire, mycode, parent, name )
{
	this->myState = false;
	connect( this, SIGNAL( clicked() ), this, SLOT( pkClicked() ) );
}


KeyboardModifier::~KeyboardModifier()
{
}

void	KeyboardModifier::release()
{
	if (this->myState)
	{
		this->wire->send(this->code, sendKey::keyUp);
		this->pkClicked();
	}
}

void	KeyboardModifier::sendDown()
{
	if (this->myState)
	{
		this->wire->send(this->code, sendKey::keyDown);
	}
}

void	KeyboardModifier::set(bool b)
{
	this->myState = b;
}

void	KeyboardModifier::pkClicked()
{
	this->myState	= !this->myState;
	this->setDown(this->myState);
}


#include "keyboardmodifier.moc"
