/***************************************************************************
                          kbconfigdlg.h  -  description
                             -------------------
    begin                : Sun Jul 8 2001
    copyright            : (C) 2001 by Leonid Zeitlin
    email                : lz@europe.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBCONFIGDLG_H
#define KBCONFIGDLG_H

#include <kdialogbase.h>
#include "kbconfig.h"

class QWidget;
class QCheckBox;
class QPushButton;
class QComboBox;
class QStringList;
class KKeyChooser;


/**Configuration dialog for KKBSwitch
  *@author Leonid Zeitlin
  */

class KBConfigDlg : public KDialogBase  {
   Q_OBJECT
public: 
	KBConfigDlg(KBConfig *kbconf, QWidget *parent=0, const char *name=0);
	~KBConfigDlg();
private: // Private attributes
  /**  */
  KListBox *lbGroups;
  /**  */
  QCheckBox *chkToggleMode;
  //QCheckBox *chkPerwindowGroup;
  QCheckBox *chkAutostart;
  QPushButton *btnChangeIcon;
  QPushButton *btnSetDefaultIcon;
  QPushButton *btnSetDefaultGroup;
  QComboBox *cbxIconType;
  QComboBox *cbxGroupScope;
  KKeyChooser *keyChooser;
  QCheckBox *chkUseShortcuts;
  QStringList m_iconpaths;
  int m_default_groupno;
  KBConfig *m_kbconf;
  /** Display the current KBSwitch configuration in the dialog */
  void showConfig();
  void saveConfig();
  void redrawIcons(KBConfig::IconStyle icon_style);
  void setupGeneralPage();
  void setupShortcutsPage();
  void checkIconDefault(int index);
private slots: // Private slots
  /** Fire up "Pick Icon" dialog */
  void slotPickIcon();
  void slotSetDefaultGroup();
  /** No descriptions */
  void slotLayoutSelected();
  /** No descriptions */
  void slotListBoxExecuted(QListBoxItem *item);
  void slotIconTypeSelected(int index);
  void slotUseShortcutsToggled(bool on);
  void slotSetDefaultIcon();
protected: // Protected methods
  /** No descriptions */
  virtual void slotApply();
  /** No descriptions */
  virtual void slotOk();
  virtual void slotCancel();
};

#endif
