/***************************************************************************
                          boldmenuitem.cpp  -  description
                             -------------------
    begin                : Sat Sep 1 2001
    copyright            : (C) 2001 by Leonid Zeitlin
    email                : lz@europe.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "boldmenuitem.h"
#include <qfont.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qstyle.h>
#include <kdebug.h>
#include <kglobalsettings.h>
#include <kdeversion.h>
#if KDE_VERSION_MAJOR >= 3
  #include <kapplication.h>
#else
  #include <kapp.h>
#endif


BoldMenuItem::BoldMenuItem(const QString &text, const QColor &active_text_color,
  bool bold)
  : m_text(text), m_active_text_color(active_text_color), m_bold(bold)
{
}

BoldMenuItem::~BoldMenuItem(){
}

void BoldMenuItem::paint(QPainter* painter, const QColorGroup& /*cg*/,
	  bool act, bool /*enabled*/, int x, int y, int w, int h)
{
  QFont font = painter->font();
  if (font.bold() != m_bold) {
    font.setBold(m_bold);
    painter->setFont(font);
  }
  //if (act) painter->setPen(KGlobalSettings::highlightedTextColor());
  //if (act) painter->setPen(cg.highlightedText());
  if (act) painter->setPen(m_active_text_color);
  kdDebug() << "bg color = " << painter->brush().color().rgb() << endl;

  painter->drawText(x, y, w, h, AlignLeft | AlignVCenter | ShowPrefix | DontClip,
    m_text);
  //KApplication::style().drawItem(painter, QRect(x, y, w, h), AlignLeft | AlignVCenter | ShowPrefix | DontClip,
  //  cg, enabled, 0, m_text);
}	


void BoldMenuItem::setFont(const QFont& font)
{
  m_size = QFontMetrics(font).size(AlignLeft | AlignVCenter | ShowPrefix | DontClip,
    m_text);
  QCustomMenuItem::setFont(font);
}

