/***************************************************************************
 *   Copyright (C) 2005 by KesieV   *
 *   kesiev@hotmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "kitty.h"
#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

static const char description[] =
    I18N_NOOP("A podcast client for KDE");

static const char version[] = "0.9";

static KCmdLineOptions options[] =
{
//    { "+[URL]", I18N_NOOP( "Document to open" ), 0 },
    KCmdLineLastOption
};

int main(int argc, char **argv)
{
    KAboutData about("kitty", I18N_NOOP("Kitty"), version, description,
		     KAboutData::License_GPL, "(C) 2005 KesieV", 0, 0, "kesiev@hotmail.com");
    about.addAuthor( "KesieV", 0, "kesiev@hotmail.com" );
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions( options );
    KApplication app;
    Kitty *mainWin = 0;
    if (app.isRestored())
    {
        RESTORE(Kitty);
    }
    else
    {
        // no session.. just start up normally
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

        /// @todo do something with the command line args here
	kitty_globals::guides.clear();
	kitty_globals::guides.append("Kitty TV Guide|http://www.kesiev.com/kittyguide/");
	kitty_globals::guides.append("DTV guide|https://channelguide.participatoryculture.org/");
	kitty_globals::guides.append("Yahoo! Podcasts|http://podcasts.yahoo.com/");
	kitty_globals::guides.append("Podcast.net|http://www.podcast.net");
	kitty_globals::kitty_url="http://www.kesiev.com/kittyguide/";
        mainWin = new Kitty();
        app.setMainWidget( mainWin );

	if (!kitty_globals::settings.start_minimized) {
        	mainWin->show();
	}

        args->clear();
    }

    // mainWin has WDestructiveClose flag by default, so it will delete itself.
    return app.exec();

}

