# Copyright (c) 2008 Hideki Ikemoto
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

class PreferenceDialog < KDE::PageDialog
  slots 'save_config()'

  def initialize(parent)
    super(parent)

    resize(600, 400)

#    addPage(nil, "General")

    @face_page = Ui::FacePage.new
    @face_page.setupUi(@face_page)
    @face_page_item = KDE::PageWidgetItem.new(@face_page, "外観")
    @face_page_item.setHeader("外観")
    @face_page_item.setIcon(KDE::Icon.new("configure"))
    addPage(@face_page_item)

    @account_page = Ui::AccountPage.new
    @account_page.setupUi(@account_page)
    @account_page_item = KDE::PageWidgetItem.new(@account_page, "Account")
    @account_page_item.setHeader("Account")
    @account_page_item.setIcon(KDE::Icon.new("network-connect"))
    addPage(@account_page_item)

    @write_page = Ui::WritePage.new
    @write_page.setupUi(@write_page)
    @write_page_item = KDE::PageWidgetItem.new(@write_page, "Write")
    @write_page_item.setHeader("Write")
    @write_page_item.setIcon(KDE::Icon.new("document-properties"))
    addPage(@write_page_item)

    connect(self, SIGNAL("okClicked()"), self, SLOT("save_config()"))

    load_config
  end

  def load_config
    config = Config.instance
    @face_page.thread_font_requester.setFont(config.thread_font)
    @account_page.id_line.text = config.user_id
    @account_page.password_line.text = config.password
    @account_page.autologin_check.setChecked(config.auto_login)
    @write_page.default_name_line.text = config.default_name
    @write_page.default_mail_line.text = config.default_mail
    @write_page.kotehan_edit.setPlainText(config.kotehan.join("\n"))
  end

  def save_config
    id = @account_page.id_line.text
    password = @account_page.password_line.text
    auto_login = @account_page.autologin_check.checked
    default_name = @write_page.default_name_line.text
    default_mail = @write_page.default_mail_line.text
    kotehan = @write_page.kotehan_edit.toPlainText.split("\n").grep(/^.+$/)
    thread_font = @face_page.thread_font_requester.font

    config = Config.instance
    config.thread_font = thread_font
    config.user_id = id
    config.password = password
    config.auto_login = auto_login
    config.default_name = default_name
    config.default_mail = default_mail
    config.kotehan = kotehan
  end
end
