#ifndef KP_SPLIT_WORKOUT_H_
#define KP_SPLIT_WORKOUT_H_

#include <glib.h>
#include <glib-object.h>
#include <libxml/tree.h>

#include "kpsplit.h"
#include "kpworkout.h"
#include "kpcalendarentry.h"

#define KP_TYPE_SPLIT_WORKOUT (kp_split_workout_get_type())
#define KP_SPLIT_WORKOUT(object) (G_TYPE_CHECK_INSTANCE_CAST ((object), KP_TYPE_SPLIT_WORKOUT, KPSplitWorkout))
#define KP_SPLIT_WORKOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KP_TYPE_SPLIT_WORKOUT, KPSplitWorkoutClass))
#define KP_IS_SPLIT_WORKOUT(object) (G_TYPE_CHECK_INSTANCE_TYPE ((object), KP_TYPE_SPLIT_WORKOUT))
#define KP_IS_SPLIT_WORKOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KP_TYPE_SPLIT_WORKOUT))
#define KP_SPLIT_WORKOUT_GET_CLASS(object) (G_TYPE_INSTANCE_GET_CLASS ((object), KP_TYPE_SPLIT_WORKOUT, KPSplitWorkoutClass))


typedef struct KPSplitWorkout_
{
  KPWorkout     parent_instance;

  GSList       *splits;  
} KPSplitWorkout;

typedef struct KPSplitWorkoutClass_ {
  KPWorkoutClass parent_class;  
} KPSplitWorkoutClass;


GType           kp_split_workout_get_type              (void);
KPSplitWorkout *kp_split_workout_new                   (void);

void            kp_split_workout_get_effective_values  (KPSplitWorkout *wo,
                                                        guint *duration,
                                                        gdouble *distance);
void            kp_split_workout_add_split             (KPSplitWorkout *wo,
                                                        const gchar *type,
                                                        guint n,
                                                        gdouble distance,
                                                        guint32 duration,
                                                        const gchar *comment);
void            kp_split_workout_add_split_struct      (KPSplitWorkout *wo,
                                                        KPSplit *split);
guint           kp_split_workout_get_whole_pace        (KPSplitWorkout *wo);
gdouble         kp_split_workout_get_whole_speed       (KPSplitWorkout *wo);
guint           kp_split_workout_get_n_splits          (KPSplitWorkout *wo);
GSList         *kp_split_workout_get_splits            (KPSplitWorkout *wo);

void            kp_split_workout_remove_split          (KPSplitWorkout *wo, 
                                                        guint split_n);
  
#endif
