#ifndef KP_MAIN_WINDOW_H_
#define KP_MAIN_WINDOW_H_

#include <gtk/gtk.h>
#include "../kptraininglog.h"
#include "kpstatusbar.h"
#include "kpview.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define KP_TYPE_MAIN_WINDOW         (kp_main_window_get_type ())
#define KP_MAIN_WINDOW(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), KP_TYPE_MAIN_WINDOW, KPMainWindow))
#define KP_MAIN_WINDOW_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), KP_TYPE_MAIN_WINDOW, KPMainWindowClass))
#define KP_IS_MAIN_WINDOW(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), KP_TYPE_MAIN_WINDOW))
#define KP_IS_MAIN_WINDOW_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), KP_TYPE_MAIN_WINDOW))
#define KP_MAIN_WINDOW_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), KP_TYPE_MAIN_WINDOW, KPMainWindowClass))


#define KP_CONF_HTML_OUTPUT_DIR     "/apps/kipina/preferences/html_output_dir"
#define KP_CONF_ACTIVE_VIEW_TYPE    "/apps/kipina/preferences/active_view_type"
#define KP_CONF_ACTIVE_TIME_PERIOD  "/apps/kipina/preferences/active_time_period"
#define KP_CONF_SHOW_SIDEBAR        "/apps/kipina/preferences/show_sidebar"
#define KP_CONF_SHOW_STATUSBAR      "/apps/kipina/preferences/show_statusbar"
#define KP_CONF_SHOW_TOOLBAR        "/apps/kipina/preferences/show_toolbar"
  
typedef struct
{
  GtkWindow       parent;

  gpointer        private_data;
} KPMainWindow;

typedef struct
{
  GtkWindowClass  parent_class;
} KPMainWindowClass;

GType              kp_main_window_get_type              (void);

GtkWidget         *kp_main_window_new                   (void);
void               kp_main_window_set_log_file          (KPMainWindow *window,
                                                         const gchar *file);
void               kp_main_window_init_log              (KPMainWindow *window,
                                                         const gchar *filename);
void               kp_main_window_add_to_import_menu    (GtkMenuItem *item);
GtkWidget         *kp_main_window_add_to_export_menu    (GtkMenuItem *item);
GtkWidget         *kp_main_window_add_to_menubar        (GtkWidget *menu);

void               kp_main_window_set_toolbar_visible   (gboolean visible);
void               kp_main_window_set_sidebar_visible   (gboolean visible);
void               kp_main_window_set_statusbar_visible (gboolean visible);

/* Interface for accessing gui parts */
KPTrainingLog     *kp_main_window_get_log               (void);
KPStatusbar       *kp_main_window_get_statusbar         (void);
KPMainWindow      *kp_main_window_get_window            (void);
KPView            *kp_main_window_get_view              (void);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* KP_MAIN_WINDOW_H_ */
