#include <gtk/gtk.h>
#include <glade/glade.h>
#include <string.h>
#include <time.h>

#include "kploginfodialog.h"
#include "kpcalendarview.h"
#include "kpmainwindow.h"
#include "kpguiutils.h"

#include "../kpworkoutmodel.h"
#include "../kpsplitworkout.h"
#include "../kptraininglog.h"
#include "../kipina-i18n.h"
#include "../kpsettings.h"
#include "../kputil.h"
#include "../kpworkout.h"


static void       kp_log_info_dialog_class_init  (KPLogInfoDialogClass *klass);
static void       kp_log_info_dialog_init        (KPLogInfoDialog *dialog);
static void       kp_log_info_dialog_finalize    (GObject *object);
static void       kp_log_info_dialog_response_cb (GtkDialog *gtkdialog,
                                                  gint response_id,
                                                  KPLogInfoDialog *dialog);
static void       kp_log_info_dialog_fill_data   (KPLogInfoDialog *dialog);


typedef struct KPLogInfoDialogPrivateData_
{
  GtkWidget     *entry_realname;
  GtkWidget     *entry_nickname;
  GtkWidget     *entry_title;
  
  GtkWidget     *text_description;
  GtkTextBuffer *text_buffer;

} KPLogInfoDialogPrivateData;


#define KP_LOG_INFO_DIALOG_PRIVATE_DATA(widget) (((KPLogInfoDialogPrivateData*) \
        (KP_LOG_INFO_DIALOG (widget)->private_data)))

static GObjectClass *parent_class = NULL;

GType
kp_log_info_dialog_get_type (void)
{
  static GType kp_log_info_dialog_type = 0;

  if (kp_log_info_dialog_type == 0) {
    static const GTypeInfo our_info = {
      sizeof (KPLogInfoDialogClass),
      NULL,
      NULL,
      (GClassInitFunc) kp_log_info_dialog_class_init,
      NULL,
      NULL,
      sizeof (KPLogInfoDialog),
      0,
      (GInstanceInitFunc) kp_log_info_dialog_init,
      NULL,
    };
    kp_log_info_dialog_type = g_type_register_static (GTK_TYPE_DIALOG,
                                                     "KPLogInfoDialog",
                                                     &our_info, 0);
  }
  return kp_log_info_dialog_type;
}


static void
kp_log_info_dialog_class_init (KPLogInfoDialogClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);

  parent_class = g_type_class_peek_parent (klass);
  object_class->finalize = kp_log_info_dialog_finalize;
}


static void
kp_log_info_dialog_init (KPLogInfoDialog *dialog)
{
  KPLogInfoDialogPrivateData *p_data;
  GladeXML *xml;

  xml = kp_gui_load ("infodialog", "infodialog");

  dialog->private_data = g_new0 (KPLogInfoDialogPrivateData, 1);
  p_data = KP_LOG_INFO_DIALOG_PRIVATE_DATA (dialog);

  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox),
                     KP_W (xml, "infodialog"));
  gtk_dialog_set_default_response (GTK_DIALOG (dialog), GTK_RESPONSE_NONE);
  gtk_dialog_add_button (GTK_DIALOG (dialog), GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE);
  
  g_signal_connect (G_OBJECT (dialog), "response",
                    G_CALLBACK (kp_log_info_dialog_response_cb), dialog);


  p_data->entry_realname = KP_W (xml, "entry_realname");
  p_data->entry_nickname = KP_W (xml, "entry_nickname");
  p_data->entry_title = KP_W (xml, "entry_title");
  p_data->text_description = KP_W (xml, "text_description");
  p_data->text_buffer = gtk_text_buffer_new (NULL);

  gtk_text_view_set_buffer (GTK_TEXT_VIEW (p_data->text_description),
                            GTK_TEXT_BUFFER (p_data->text_buffer));
  g_object_unref (G_OBJECT (xml));
  kp_log_info_dialog_fill_data (dialog);
}


static void
kp_log_info_dialog_finalize (GObject *object)
{
  KPLogInfoDialogPrivateData *p_data;
  p_data = KP_LOG_INFO_DIALOG_PRIVATE_DATA (object); 
  
  g_free (p_data);

  G_OBJECT_CLASS (parent_class)->finalize (object);
}


GtkWidget *
kp_log_info_dialog_new (void)
{
  return g_object_new (KP_TYPE_LOG_INFO_DIALOG, NULL);
}


static void
kp_log_info_dialog_response_cb (GtkDialog *gtk_dialog, int response_id,
                                KPLogInfoDialog *dialog)
{
  KPLogInfoDialogPrivateData *p_data;
  KPTrainingLog *log;
  GtkTextIter s;
  GtkTextIter e;
  gchar *description;
  const gchar *realname;
  const gchar *nickname;
  const gchar *title;

  p_data = KP_LOG_INFO_DIALOG_PRIVATE_DATA (dialog);

  log = kp_main_window_get_log ();
  g_return_if_fail (KP_IS_TRAINING_LOG (log));

  realname = gtk_entry_get_text (GTK_ENTRY (p_data->entry_realname));
  nickname = gtk_entry_get_text (GTK_ENTRY (p_data->entry_nickname));
  title = gtk_entry_get_text (GTK_ENTRY (p_data->entry_title));

  gtk_text_buffer_get_start_iter (p_data->text_buffer, &s);
  gtk_text_buffer_get_end_iter (p_data->text_buffer, &e);

  description = gtk_text_buffer_get_text (p_data->text_buffer, &s, &e, TRUE);

  kp_training_log_add_info_entry (log, "realname", realname);
  kp_training_log_add_info_entry (log, "nickname", nickname);
  kp_training_log_add_info_entry (log, "title", title);
  kp_training_log_add_info_entry (log, "description", description);

  g_free (description);
}


static void
kp_log_info_dialog_fill_data (KPLogInfoDialog *dialog)
{
  KPLogInfoDialogPrivateData *p_data;
  KPTrainingLog *log;
  const gchar *description;
  const gchar *realname;
  const gchar *nickname;
  const gchar *title;
  
  p_data = KP_LOG_INFO_DIALOG_PRIVATE_DATA (dialog);
  log = kp_main_window_get_log ();

  g_return_if_fail (KP_IS_TRAINING_LOG (log));
 
  description = kp_training_log_get_info_entry (log, "description");
  realname = kp_training_log_get_info_entry (log, "realname");
  nickname = kp_training_log_get_info_entry (log, "nickname");
  title = kp_training_log_get_info_entry (log, "title");
 
  if (realname)
    gtk_entry_set_text (GTK_ENTRY (p_data->entry_realname), realname);
  if (nickname)
    gtk_entry_set_text (GTK_ENTRY (p_data->entry_nickname), nickname);
  if (title)
    gtk_entry_set_text (GTK_ENTRY (p_data->entry_title), title);
  if (description)
    gtk_text_buffer_set_text (p_data->text_buffer, description, -1);
}

