/**
 * Operations for working with mp3 files
 */
static const char* rcsid __attribute__((unused)) =
"$Id: mp3.cpp,v 1.1 2002/07/01 20:09:55 tsirc Exp $";


// kionjb
#include "mp3.h"

// kde
#include <kdebug.h>

// qt
#include <qfile.h>
#include <qstring.h>

// posix
#include <stdint.h>


/** kb/s */
static const unsigned
bitrate_table[ 16][ 5] = {
	{  0,   0,   0,   0,   0},
	{ 32,  32,  32,  32,   8},
	{ 64,  48,  40,  48,  16},
	{ 96,  56,  48,  56,  24},
	{128,  64,  56,  64,  32},
	{160,  80,  64,  80,  40},
	{192,  96,  80,  96,  48},
	{224, 112,  96, 112,  56},
	{256, 128, 112, 128,  64},
	{288, 160, 128, 144,  80},
	{320, 192, 160, 160,  96},
	{352, 224, 192, 176, 112},
	{384, 256, 224, 192, 128},
	{416, 320, 256, 224, 144},
	{448, 384, 320, 256, 160},
	{  0,   0,   0,   0,   0},
};


/** which column of the bitrate table to use for a given encoding/layer */
static const int
column_table[ 8] = {
	-1, 4, 4, 3, -1, 2, 1, 0
};


/* ----------------------------------------------------------------------- */
unsigned
getDuration( const QString& filename)
{
	QFile file( filename);
	file.open( IO_ReadOnly);
	// find the sync
	uint32_t header = 0;
	while( !file.atEnd()) {
		if( file.getch() != 0xff)
			continue;
		if( file.getch() & 0xf0 != 0xf0)
			continue;
		// found the sync
		file.at( file.at() - 2);
		file.readBlock( (char*)&header, sizeof( header));
		break;
	}
	file.close();

	if( !header) {
		kdDebug( 7182) << "getDuration: " << filename
			<< " has no sync\n";
		return 0;
	}

	kdDebug( 7182) << "getDuration: header = " << header << endl;
	if( header & 0xf0ff != 0xf0ff) {
		kdDebug( 7182) << "getDuration: " << filename
			<< " is not a valid mp3 file (bad sync)\n";
		return 0;
	}
	unsigned layer = (header & 0x700) >> 8;
	unsigned bitrate = (header & 0xf00000) >> 20;
	int column = column_table[ layer];
	if( column == -1) {
		kdDebug( 7182) << "getDuration: " << filename
			<< " is not a valid mp3 file (bad bitrate)\n";
		return 0;
	}
	unsigned byterate = 1024 / 8 * bitrate_table[ bitrate][ layer];
	unsigned duration = file.size() / byterate;
	kdDebug( 7182) << "getDuration: duration = " << duration << endl;
	return duration;
}
