
#ifndef _beagk_H_
#define _beagk_H_

#include <qcstring.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qdict.h>
#include <qvaluelist.h>

#include <kurl.h>
#include <kio/global.h>
#include <kio/slavebase.h>

#include "beaglesearch.h"

class QCString;

class kio_beagkProtocol :public QObject, public KIO::SlaveBase 
{
Q_OBJECT
public:
    kio_beagkProtocol(const QCString &pool_socket, const QCString &app_socket);
    virtual ~kio_beagkProtocol();
    virtual void mimetype(const KURL& url);
    virtual void get(const KURL& url);
    virtual void stat(const KURL& url);
    virtual void listDir(const KURL& url);

private slots:
    void searchHasOutput(BeagleResultList &results);
    void searchFinished();
	void searchError (const QString& error);

private:
    BeagleSearch beagle_search;    
    
private:
    QString URL_ToSearchString(const KURL &url);
//    void addHit(const QString& uri, const QString& title, const QString& mime_type, HitType type);
};

#endif
