/***************************************************************************
 *   Copyright (C) 2004 by Ingo Stierand, Stierand-LinuxIt                 *
 *   linuxit@web.de                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef TINSTALLDATA_H
#define TINSTALLDATA_H

#include <qdir.h>
#include <qurl.h>
#include <qdatetime.h>


/**
  */
class TInstallData {
  public:
    TInstallData();
    ~TInstallData();

    // installation target date and label
    QDateTime dateTime;
    QString dateLabel;
    
    // the original url of the local file to be installed
    QUrl sourceFile;
    // the resulting url of the tar package file
    QUrl packageFile;
    QString packageFileBase;
    QString packageName;
    QString packageVersion;
    QString packageRelease;
    // if the package should be moved after installation
    bool packageKeep;
    // if the package should be deleted after failure
    bool packageDeleteOnFail;
    // the directory where the tar package file (and the package itself) should reside
    QDir packageDir;
    // the base directory for installation processing
    QDir installDir;
    QString installDirName;
    // flag if the installation directory is created (needed for cleanup)
    bool installDirCreated;
    // the make directory
    QDir makeDir;
    QString makeDirName;
    // flag if the make directory should be kept for later uninstall
    bool makeDirKeep;

    // the destination directory for the final installation
    QDir destDir;
    // configuration options string
    QString configureOpts;
};

#endif
