/***************************************************************************
 *   Copyright (C) 2007 by Ken Werner                                      *
 *   ken.werner@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef BATTERYSRC_H
#define BATTERYSRC_H
#include "labelsource.h"
#include "threadedtrigger.h"
#include <qfile.h>
#include <qstring.h>
#include <list>
#include <hal/libhal.h>

/**
 * BatterySrc fetches the state of charge of the battery from HAL
 * @author Ken Werner
 */
class BatterySrc : public LabelSource {
	Q_OBJECT //macro which activates signals and slots (moc)
public:
	/**
	 * Creates a new Source
	 */
	BatterySrc(QWidget* inParent, QString inUDI);
	virtual ~BatterySrc();
	
	/**
	 * Creates instances of that Source (and returns pointers to them)
	 */
	static std::list<Source*> createInstances(QWidget* inParent);

	/**
	 * Fetches and returns the value of this source
	 * This method is called from a thread so don't call it directly
	 */
	virtual QString fetchValue();

private:
	/**
	 * triggers the fetchValue method
	 */
	ThreadedTrigger mTrigger;

	/**
	 * The hal udi of that battery source
	 */	
	QString mUDI;

	/**
	 * The local hal context
	 */	
	LibHalContext* mLibHalContext;

	/**
	 * The local dbus error object
	 */	
	DBusError mDBusError;

};
#endif //BATTERYSRC_H
