/***************************************************************************
 *   Copyright (C) 2006 by Ken Werner                                      *
 *   ken.werner@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "acpithermalsrc.h"
#include <qtextstream.h> 
#include <qdir.h>
#include <klocale.h>

ACPIThermalSrc::ACPIThermalSrc(QWidget* inParent, const QFile& inSourceFile):
		LabelSource(inParent),
		mSourceFile(inSourceFile.name()),
		mTrigger(this){
	mID = mSourceFile.name().section('/', -2, -2, QString::SectionSkipEmpty);
	mName = mID;
	mDescription = i18n("This source is provided by the Linux ACPI Thermal Zone driver.");
}

ACPIThermalSrc::~ACPIThermalSrc(){
}

std::list<Source*>ACPIThermalSrc::createInstances(QWidget* inParent){
	std::list<Source*> list;
	QDir d( "/proc/acpi/thermal_zone" );
	if( d.exists() ){
		d.setFilter( QDir::Dirs | QDir::NoSymLinks );
		d.setSorting( QDir::Name);
		for( unsigned int i = 0; i < d.count(); i++ ){
			if((d[i] != ".") && (d[i] != "..")){
				QFile acpiFile(d.canonicalPath() + "/" + d[i] + "/temperature");
				list.push_back(new ACPIThermalSrc(inParent, acpiFile));
			}
		}
	}
	return list;
}

QString ACPIThermalSrc::fetchValue() {
	QString s = "n/a";
	if(mSourceFile.open(IO_ReadOnly)){
		QTextStream textStream(&mSourceFile);
		s = textStream.readLine();
		mSourceFile.close();
		s = s.remove("temperature:").stripWhiteSpace();
		s = formatTemperature(s.left(s.length()-1));
	}
	return s;
}

