/* $Id: permanentvariables.c,v 1.10 2007/11/25 18:19:36 ekalin Exp $ */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <kcconfig.h>
#endif

#include <string.h>
#include <libintl.h>
#include <locale.h>
#include <gtk/gtk.h>
#include <glade/glade.h>

/* Perl includes */
#include <EXTERN.h>
#include <perl.h>
#include <XSUB.h>

#include "kildclient.h"
#include "perlscript.h"


/*************************
 * File global variables *
 *************************/


/***********************
 * Function prototypes *
 ***********************/


void
load_permanent_variables(World *world)
{
  gchar *variables_file;

  if (world->file) {
    variables_file = g_strdup_printf("%s.var", world->file);
    perl_script_import_file(world->perl_interpreter, variables_file);
    g_free(variables_file);
  }
}


void
save_permanent_variables(World *world)
{
  PerlInterpreter *old_interpreter;
  gchar           *variables_file;
  FILE            *fp;
  GSList        *iter;
  gchar           *varname;
  gchar           *command;
  SV              *retval;

  if (!world->file) {
    return;
  }

  variables_file = g_strdup_printf("%s.var", world->file);
  if (!world->permanent_variables) {
    /* We don't care if it doesn't exist */
    unlink(variables_file);
    g_free(variables_file);
    return;
  }

  fp = fopen(variables_file, "w");
  if (!fp) {
    GtkWidget *dlg = gtk_message_dialog_new(GTK_WINDOW(wndMain),
                                            GTK_DIALOG_DESTROY_WITH_PARENT,
                                            GTK_MESSAGE_ERROR,
                                            GTK_BUTTONS_CLOSE,
                                            _("Could not open file '%s': %s\n"
                                              "Variables were not saved."),
                                            variables_file,
                                            g_strerror(errno));
    gtk_window_set_title(GTK_WINDOW(dlg), _("KildClient Warning"));
    gtk_dialog_run(GTK_DIALOG(dlg));
    gtk_widget_destroy(dlg);
    g_free(variables_file);
    return;
  }

  old_interpreter = PERL_GET_CONTEXT;
  PERL_SET_CONTEXT(world->perl_interpreter);

  iter = world->permanent_variables;
  while (iter) {
    varname = (char *) iter->data;

    if (varname[0] == '$') {
      command = g_strdup_printf("Encode::_utf8_off(%s);"
                                "$__serialized = Data::Dumper->Dump([%s], ['%s']);"
                                "Encode::_utf8_on(%s)",
                                varname, varname, varname+1, varname);
    } else {
      command = g_strdup_printf("map { Encode::_utf8_off($_) } %s;"
                                "$__serialized = Data::Dumper->Dump([\\%s], ['*%s']);"
                                "map { Encode::_utf8_on($_) } %s;",
                                varname, varname, varname+1, varname);
    }

    eval_pv(command, TRUE);
    retval = get_sv("__serialized", FALSE);
    fprintf(fp, "%s", SvPV_nolen(retval));

    g_free(command);

    /* A hack, possibly */
    if (varname[0] == '$') {
      command = g_strdup_printf("Encode::_utf8_on(%s);\n", varname);
      fprintf(fp, "%s", command);
      g_free(command);
    } else if (varname[0] == '@') {
      command = g_strdup_printf("map { Encode::_utf8_on($_) } %s;\n",
                                varname);
      fprintf(fp, "%s", command);
      g_free(command);
    }

    iter = iter->next;
  }

  fclose(fp);
  g_free(variables_file);

  PERL_SET_CONTEXT(old_interpreter);
}


gboolean
move_var(World *world, gint old_pos, gint new_pos)
{
  GSList   *varitem;
  gpointer  var;

  varitem = g_slist_nth(world->permanent_variables, old_pos);
  if (!varitem) {
    return FALSE;
  }
  var = varitem->data;

  world->permanent_variables
    = g_slist_delete_link(world->permanent_variables, varitem);
  world->permanent_variables
    = g_slist_insert(world->permanent_variables, var, new_pos);

  we_var_delete_var(world, var);
  we_var_insert_var(world, var, new_pos);

  return TRUE;
}


void
free_permanent_variable(gchar *variable, gpointer data)
{
  g_free(variable);
}

