/////////////////////////////////////////////////////////////////////////////

// Name:        dialog_freeroute_exchange.cpp
// Purpose:
// Author:      jean-pierre Charras
// Modified by:
// Created:     14/03/2008 09:19:27
// RCS-ID:
// Copyright:   kicad team
// Licence:
/////////////////////////////////////////////////////////////////////////////

// Generated by DialogBlocks (unregistered), 14/03/2008 09:19:27

////@begin includes
////@end includes

#include "fctsys.h"
#include "appl_wxstruct.h"
#include "common.h"
#include "gestfich.h"
#include "pcbnew.h"

#include "dialog_freeroute_exchange.h"

////@begin XPM images
////@end XPM images

#define FREEROUTE_URL_KEY wxT( "freeroute_url" )
#define FREEROUTE_RUN_KEY wxT( "freeroute_command" )


/**********************************************************************/
void WinEDA_PcbFrame::Access_to_External_Tool( wxCommandEvent& event )
/**********************************************************************/

/* Run an external tool (currently, only freeroute)
 */
{
    dialog_freeroute_exchange dialog( this );

    dialog.ShowModal();
}


/*!
 * dialog_freeroute_exchange type definition
 */

IMPLEMENT_DYNAMIC_CLASS( dialog_freeroute_exchange, wxDialog )


/*!
 * dialog_freeroute_exchange event table definition
 */

BEGIN_EVENT_TABLE( dialog_freeroute_exchange, wxDialog )

////@begin dialog_freeroute_exchange event table entries
    EVT_INIT_DIALOG( dialog_freeroute_exchange::OnInitDialog )
    EVT_CLOSE( dialog_freeroute_exchange::OnCloseWindow )

    EVT_BUTTON( ID_BUTTON4, dialog_freeroute_exchange::OnButton4Click )

    EVT_BUTTON( ID_BUTTON5, dialog_freeroute_exchange::OnButton5Click )

    EVT_BUTTON( ID_BUTTON6, dialog_freeroute_exchange::OnButton6Click )

    EVT_BUTTON( ID_BUTTON7, dialog_freeroute_exchange::OnButton7Click )

    EVT_TEXT( ID_TEXTCTRL2, dialog_freeroute_exchange::OnTextEditFrUrlUpdated )

    EVT_BUTTON( wxID_CANCEL, dialog_freeroute_exchange::OnCancelClick )

////@end dialog_freeroute_exchange event table entries

END_EVENT_TABLE()


/*!
 * dialog_freeroute_exchange constructors
 */

dialog_freeroute_exchange::dialog_freeroute_exchange()
{
    Init();
}


dialog_freeroute_exchange::dialog_freeroute_exchange( wxWindow* parent,
                                                      wxWindowID id,
                                                      const wxString& caption,
                                                      const wxPoint& pos,
                                                      const wxSize& size,
                                                      long style )
{
    m_Parent = (WinEDA_PcbFrame*) parent;
    Init();
    Create( parent, id, caption, pos, size, style );
}


/*!
 * dialog_freeroute_exchange creator
 */

bool dialog_freeroute_exchange::Create( wxWindow* parent,
                                        wxWindowID id,
                                        const wxString& caption,
                                        const wxPoint& pos,
                                        const wxSize& size,
                                        long style )
{
////@begin dialog_freeroute_exchange creation
    SetExtraStyle(wxWS_EX_BLOCK_EVENTS);
    wxDialog::Create( parent, id, caption, pos, size, style );

    CreateControls();
    if (GetSizer())
    {
        GetSizer()->SetSizeHints(this);
    }
    Centre();
////@end dialog_freeroute_exchange creation
    return true;
}


/*!
 * dialog_freeroute_exchange destructor
 */

dialog_freeroute_exchange::~dialog_freeroute_exchange()
{
////@begin dialog_freeroute_exchange destruction
////@end dialog_freeroute_exchange destruction
}


/*!
 * Member initialisation
 */

void dialog_freeroute_exchange::Init()
{
////@begin dialog_freeroute_exchange member initialisation
    m_FreeRouteSetupChanged = false;
    m_ExportDSN = NULL;
    m_FreerouteURLName = NULL;
////@end dialog_freeroute_exchange member initialisation
}


/*!
 * Control creation for dialog_freeroute_exchange
 */

void dialog_freeroute_exchange::CreateControls()
{
////@begin dialog_freeroute_exchange content construction
    // Generated by DialogBlocks, Tue 25 Mar 2008 11:02:20 CDT (unregistered)

    dialog_freeroute_exchange* itemDialog1 = this;

    wxBoxSizer* itemBoxSizer2 = new wxBoxSizer(wxVERTICAL);
    itemDialog1->SetSizer(itemBoxSizer2);

    wxPanel* itemPanel3 = new wxPanel( itemDialog1, ID_PANEL1, wxDefaultPosition, wxDefaultSize, wxRAISED_BORDER|wxTAB_TRAVERSAL );
    itemBoxSizer2->Add(itemPanel3, 1, wxGROW|wxALL, 5);

    wxBoxSizer* itemBoxSizer4 = new wxBoxSizer(wxHORIZONTAL);
    itemPanel3->SetSizer(itemBoxSizer4);

    wxStaticBox* itemStaticBoxSizer5Static = new wxStaticBox(itemPanel3, wxID_ANY, _T(""));
    wxStaticBoxSizer* itemStaticBoxSizer5 = new wxStaticBoxSizer(itemStaticBoxSizer5Static, wxVERTICAL);
    itemBoxSizer4->Add(itemStaticBoxSizer5, 0, wxGROW|wxALL, 5);

    m_ExportDSN = new wxButton( itemPanel3, ID_BUTTON4, _("Export a Specctra Design (*.dsn) File"), wxDefaultPosition, wxDefaultSize, 0 );
    if (dialog_freeroute_exchange::ShowToolTips())
        m_ExportDSN->SetToolTip(_("Export a Specctra DSN file (to FreeRouter)"));
    itemStaticBoxSizer5->Add(m_ExportDSN, 0, wxGROW|wxALL, 5);

    wxButton* itemButton7 = new wxButton( itemPanel3, ID_BUTTON5, _("Launch FreeRouter via Java Web Start"), wxDefaultPosition, wxDefaultSize, 0 );
    if (dialog_freeroute_exchange::ShowToolTips())
        itemButton7->SetToolTip(_("Use Java Web Start function to run FreeRouter via Internet (or your Browser if not found)"));
    itemStaticBoxSizer5->Add(itemButton7, 0, wxGROW|wxALL, 5);

    wxButton* itemButton8 = new wxButton( itemPanel3, ID_BUTTON6, _("Back Import the Specctra Session (*.ses) File"), wxDefaultPosition, wxDefaultSize, 0 );
    if (dialog_freeroute_exchange::ShowToolTips())
        itemButton8->SetToolTip(_("Merge a session file created by FreeRouter with the current board."));
    itemStaticBoxSizer5->Add(itemButton8, 0, wxGROW|wxALL, 5);

    wxStaticBox* itemStaticBoxSizer9Static = new wxStaticBox(itemPanel3, wxID_ANY, _T(""));
    wxStaticBoxSizer* itemStaticBoxSizer9 = new wxStaticBoxSizer(itemStaticBoxSizer9Static, wxVERTICAL);
    itemBoxSizer4->Add(itemStaticBoxSizer9, 1, wxGROW|wxALL, 5);

    wxButton* itemButton10 = new wxButton( itemPanel3, ID_BUTTON7, _("Visit FreeRouting.net website"), wxDefaultPosition, wxDefaultSize, 0 );
    if (dialog_freeroute_exchange::ShowToolTips())
        itemButton10->SetToolTip(_("Launch your browser and go to the FreeRouting.net website"));
    itemStaticBoxSizer9->Add(itemButton10, 0, wxGROW|wxALL, 5);

    wxStaticText* itemStaticText11 = new wxStaticText( itemPanel3, wxID_STATIC, _("FreeRouting.net URL"), wxDefaultPosition, wxDefaultSize, 0 );
    itemStaticBoxSizer9->Add(itemStaticText11, 0, wxGROW|wxLEFT|wxRIGHT|wxTOP, 5);

    m_FreerouteURLName = new wxTextCtrl( itemPanel3, ID_TEXTCTRL2, _T(""), wxDefaultPosition, wxDefaultSize, 0 );
    if (dialog_freeroute_exchange::ShowToolTips())
        m_FreerouteURLName->SetToolTip(_("The URL of the FreeRouting.net website"));
    itemStaticBoxSizer9->Add(m_FreerouteURLName, 0, wxGROW|wxLEFT|wxRIGHT|wxBOTTOM, 5);

    wxStdDialogButtonSizer* itemStdDialogButtonSizer13 = new wxStdDialogButtonSizer;

    itemBoxSizer2->Add(itemStdDialogButtonSizer13, 0, wxGROW|wxALL, 5);
    wxButton* itemButton14 = new wxButton( itemDialog1, wxID_CANCEL, _("&Close"), wxDefaultPosition, wxDefaultSize, 0 );
    itemStdDialogButtonSizer13->AddButton(itemButton14);

    itemStdDialogButtonSizer13->Realize();

////@end dialog_freeroute_exchange content construction

    wxString msg;
    wxGetApp().m_EDA_Config->Read( FREEROUTE_URL_KEY, &msg );
    if( msg.IsEmpty() )
        m_FreerouteURLName->SetValue( wxT( "http://www.freerouting.net/" ) );
    else
        m_FreerouteURLName->SetValue( msg );
}


/*!
 * Should we show tooltips?
 */

bool dialog_freeroute_exchange::ShowToolTips()
{
    return true;
}


/*!
 * Get bitmap resources
 */

wxBitmap dialog_freeroute_exchange::GetBitmapResource( const wxString& name )
{
    // Bitmap retrieval
////@begin dialog_freeroute_exchange bitmap retrieval
    wxUnusedVar(name);
    return wxNullBitmap;
////@end dialog_freeroute_exchange bitmap retrieval
}


/*!
 * Get icon resources
 */

wxIcon dialog_freeroute_exchange::GetIconResource( const wxString& name )
{
    // Icon retrieval
////@begin dialog_freeroute_exchange icon retrieval
    wxUnusedVar(name);
    return wxNullIcon;
////@end dialog_freeroute_exchange icon retrieval
}


/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_CREATE_EXPORT_DSN_FILE
 */

void dialog_freeroute_exchange::OnButton4Click( wxCommandEvent& event )
{
    m_Parent->ExportToSpecctra( event );
}


/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_IMPORT_FREEROUTE_DSN_FILE
 */

void dialog_freeroute_exchange::OnButton6Click( wxCommandEvent& event )
{
    m_Parent->ImportSpecctraSession(  event );
}


/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_RUN_FREEROUTE
 */

void dialog_freeroute_exchange::OnButton5Click( wxCommandEvent& event )
{
    wxString FullFileName = FindKicadFile( wxT( "freeroute.jnlp" ) );
    wxString command;

    if( wxFileExists( FullFileName ) )
    {
        // Wrap FullFileName in double quotes in case it has C:\Program Files in it.
        // The space is interpreted as an argument separator.
        command << wxT("javaws") << wxChar(' ') << wxChar('"') << FullFileName << wxChar('"');
        ProcessExecute( command );
        return;
    }

    command = m_FreerouteURLName->GetValue() + wxT( "/java/freeroute.jnlp" );

    wxLaunchDefaultBrowser( command );
}


/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON
 */

void dialog_freeroute_exchange::OnButton7Click( wxCommandEvent& event )
{
    wxString command = m_FreerouteURLName->GetValue();

    wxLaunchDefaultBrowser( command );
}


/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_CLOSE
 */

void dialog_freeroute_exchange::OnCancelClick( wxCommandEvent& event )
{
    D(printf("OnCancelClick\n");)
    Close( true );
}


/*!
 * wxEVT_CLOSE_WINDOW event handler for ID_DIALOG_FREEROUTE_EXCHANGE
 */

void dialog_freeroute_exchange::OnCloseWindow( wxCloseEvent& event )
{
    D(printf("OnCloseWindow\n");)

    if( m_FreeRouteSetupChanged )  // Save new config
    {
        wxGetApp().m_EDA_Config->Write( FREEROUTE_URL_KEY,
                                        m_FreerouteURLName->GetValue() );
    }

    Destroy();
}


/*!
 * wxEVT_COMMAND_TEXT_UPDATED event handler for ID_TEXT_EDIT_FR_URL
 */

void dialog_freeroute_exchange::OnTextEditFrUrlUpdated( wxCommandEvent& event )
{
    m_FreeRouteSetupChanged = true;
}



/*!
 * wxEVT_INIT_DIALOG event handler for ID_DIALOG_FREEROUTE_EXCHANGE
 */

void dialog_freeroute_exchange::OnInitDialog( wxInitDialogEvent& event )
{
    m_ExportDSN->SetFocus();


////@begin wxEVT_INIT_DIALOG event handler for ID_DIALOG_FREEROUTE_EXCHANGE in dialog_freeroute_exchange.
    // Before editing this code, remove the block markers.
    event.Skip();
////@end wxEVT_INIT_DIALOG event handler for ID_DIALOG_FREEROUTE_EXCHANGE in dialog_freeroute_exchange.
}

