/***************************************************************************
 *   Copyright (C) 2004 by Emil Stoyanov                                   *
 *   emosto@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kiaxaddressbook.h"

int KiaxAddressBook::createNewContact()
{
    KiaxContact * c = new KiaxContact("user", "1234567890", "1");
    return addContact(c);
}

int KiaxAddressBook::addContact(KiaxContact * contact)
{
    inSort(contact);
    int index = find(contact);
    return index;
}

void KiaxAddressBook::removeContact(int contactNumber) {
  KiaxContact* c = at(contactNumber);
  c->remove();
  remove(contactNumber);
}

KiaxContact* KiaxAddressBook::getContact(int i)
{
    return at(i);
}

KiaxAddressBook KiaxAddressBook::getContacts()
{
    return *this;
}

void KiaxAddressBook::save() {
   for (uint i=0;i<count();i++) {
      KiaxContact * c = at(i);
      c->save();
   }
}

void KiaxAddressBook::load() {
  
  QSettings * settings = getSettings();
  QStringList contactsList = settings->subkeyList("/kiax/contacts");
  delete settings;
    
  setAutoDelete(true); // this will dispose all 
  clear();
  
  contactsList.sort();
  
  for (QStringList::Iterator it = contactsList.begin();it!=contactsList.end(); ++it) {
     KiaxContact * c = new KiaxContact("","","");
     c->load(*it);
     addContact(c);
  }
  
}

QSettings * KiaxAddressBook::getSettings()
{
  QSettings * settings = new QSettings();
  settings->setPath("kiax.org","kiax", QSettings::User);// userspace
  return settings;
}

int KiaxAddressBook::compareItems ( void* item1, void* item2 ) {
  KiaxContact* i1 = (KiaxContact*)item1;
  KiaxContact* i2 = (KiaxContact*)item2;
  if (i1->getName()>i2->getName()) return 1;
  else if (i1->getName()<i2->getName()) return -1;
    else return 0;
}
