/***************************************************************************
 *   Copyright (C) 2004 by Emil Stoyanov                                   *
 *   emosto@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef KIAXACCOUNTWIZARD_H
#define KIAXACCOUNTWIZARD_H

#include <qlineedit.h>
#include <qpushbutton.h>
#include <qptrlist.h>
#include <qcombobox.h>
#include <qlabel.h>

#include "kiaxaccount.h"
#include "kiaxpreset.h"
#include "accountwizard.h"

class KiaxAccountWizard : public AccountWizardUI
{
  Q_OBJECT

public:
  KiaxAccountWizard(QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
  ~KiaxAccountWizard();
  void init();
  void createAccountFromPreset(int presetNumber);
  QPtrList<KiaxPreset> getPresets();
  
  /*$PUBLIC_FUNCTIONS$*/

public slots:
  /*$PUBLIC_SLOTS$*/
  virtual void callerIdNumberEdit_textChanged(const QString& string);
  virtual void usernameEdit_textChanged(const QString& string);
  virtual void passwordEdit_textChanged(const QString& string);
  virtual void accountNameEdit_textChanged(const QString& string);
  virtual void callerIdNameEdit_textChanged(const QString& string);
  virtual void networkNameComboBox_activated(int highlighted);
  virtual void registerButton_pressed();
  virtual void homePageButton_pressed();
      
protected:
  /*$PROTECTED_FUNCTIONS$*/

protected slots:
  /*$PROTECTED_SLOTS$*/
  virtual void          back();
  virtual void          next();

private:

  void loadPresets();  
  
private:
  
  QPtrList<KiaxPreset> presets;
  int selectedPreset;

signals:

  void accountCreated();
  
};

#endif

