/*
    This file is part of the KDE project.
    Copyright (c) 2006-2007 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


#ifndef KHALKHI_DATAACTIONSERVICE_H
#define KHALKHI_DATAACTIONSERVICE_H


// lib specific
#include "serviceaction.h"
#include "service.h"

class QMimeSource;
namespace KABC { class Addressee; }


namespace Khalkhi {

class DataActionServiceClient;


// TODO: show unavailability instead of ignoring? Or both, chosen by service?
/**
 * Base class for all data action services.
 *
 * A service operates on an item of a given property of a person.
 * 
 */
class KDE_EXPORT DataActionService : public Service
{
    Q_OBJECT
public:
    DataActionService( QObject* Parent, const char* Name, const QStringList& Arguments );
    virtual ~DataActionService();

public: // interface
    virtual ServiceAction action( const KABC::Addressee &Person,
                                  QMimeSource *Data, int Flags = NoFlags ) const = 0;

    /** does the service */
    virtual void execute( const KABC::Addressee &Person, QMimeSource *Data ) = 0;

    /** @returns if the service is possible for the item; defaults to return true */
    virtual bool supports( QMimeSource *Data ) const;
    virtual bool supports( QMimeSource *DataSource, const KABC::Addressee &Person ) const;

    /** @returns if the service is available currently; defaults to return true */
    virtual bool isAvailableFor( QMimeSource *Data ) const;
    virtual bool isAvailableFor( QMimeSource *DataSource, const KABC::Addressee &Person ) const;

    /** if ItemIndex = -1 register all items */
    virtual void registerClient( DataActionServiceClient* Client );
    virtual void unregisterClient( DataActionServiceClient* Client );
};

}

#endif
