/***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA  02111-1307, USA.                                          *
 ***************************************************************************/

//Own
#include "view.h"

//KDE
#include <klocale.h>

//KGRUBEditor
#include "settings.h"
#include "core/filetransactions.h"

View::View( QWidget *parent ) : KDialog( parent )
{
	setupUi( this );
	setAttribute( Qt::WA_DeleteOnClose );
	setCaption( i18n( "View Files" ) );
	setWindowIcon( KIcon( "view-list-text" ) );

	tabWidget->setTabText( 0, Settings::menulst().path() );
	tabWidget->setTabText( 1, Settings::devicemap().path() );

	textEdit_menulst->setText( FileTransactions::view( Settings::menulst().path() ) );
	textEdit_devicemap->setText( FileTransactions::view( Settings::devicemap().path() ) );
}
