/***************************************************************************
 *   Copyright (C) 2007-2012 by Marcel Hasler                              *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This file is part of KGmailNotifier.                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program. If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/

#include "atomcontenthandler.h"

#define PATH_FULLCOUNT "/feed/fullcount"
#define PATH_NAME  "/feed/entry/author/name"
#define PATH_TITLE  "/feed/entry/title"

// ------------------------------------------------------------------------------------------------------------------- //
//    Construction & Destruction                                                                                       //
// ------------------------------------------------------------------------------------------------------------------- //

AtomContentHandler::AtomContentHandler()
    : QXmlDefaultHandler()
{
}

// ------------------------------------------------------------------------------------------------------------------- //

AtomContentHandler::~AtomContentHandler()
{
}


// ------------------------------------------------------------------------------------------------------------------- //
//    Public methods reimplemented from class QXmlDefaultHandler                                                       //
// ------------------------------------------------------------------------------------------------------------------- //

bool AtomContentHandler::startDocument()
{
    // Reset everything
    m_currentPath.clear();
    m_numEntriesParsed = 0;

    m_messageCount = 0;
    m_lastSubject = "";
    m_lastSender = "";

    return true;
}

// ------------------------------------------------------------------------------------------------------------------- //

bool AtomContentHandler::startElement(const QString&, const QString&, const QString &name, const QXmlAttributes&)
{
    m_currentPath.push_back(name);

    if (name == "entry")
        m_numEntriesParsed++;

    return true;
}

// ------------------------------------------------------------------------------------------------------------------- //

bool AtomContentHandler::endElement(const QString&, const QString&, const QString&)
{
    m_currentPath.pop_back();
    return true;
}

// ------------------------------------------------------------------------------------------------------------------- //

bool AtomContentHandler::characters(const QString& value)
{
    QString path = currentPath();

    if (path == PATH_FULLCOUNT)
        m_messageCount = value.toInt();
    else if (path == PATH_TITLE && m_numEntriesParsed == 1) // We're only interested in the last subject and sender
        m_lastSubject = value;
    else if (path == PATH_NAME && m_numEntriesParsed == 1)
        m_lastSender = value;

    return true;
}


// ------------------------------------------------------------------------------------------------------------------- //
//    Public access methods                                                                                            //
// ------------------------------------------------------------------------------------------------------------------- //

unsigned int AtomContentHandler::messageCount() const
{
    return m_messageCount;
}

// ------------------------------------------------------------------------------------------------------------------- //

const QString& AtomContentHandler::lastSubject() const
{
    return m_lastSubject;
}

// ------------------------------------------------------------------------------------------------------------------- //

const QString& AtomContentHandler::lastSender() const
{
    return m_lastSender;
}


// ------------------------------------------------------------------------------------------------------------------- //
//    Private helper function
//      Composes and returns a string containing the current path
//      in the xml file (e.g., "/feed/entry/author/email")
// ------------------------------------------------------------------------------------------------------------------- //

QString AtomContentHandler::currentPath() const
{
    QString currentPath = "";

    for (unsigned int i = 0; i < m_currentPath.size(); i++)
        currentPath = currentPath + "/" + m_currentPath.at(i);

    return currentPath;
}

// ------------------------------------------------------------------------------------------------------------------- //
