/***************************************************************************
 *   Copyright (C) 2007-2009 by Marcel Hasler                              *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This file is part of KGmailNotifier.                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program. If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/

#include "configuration.h"
#include "passworditem.h"

#include <QTextStream>
static QTextStream cout(stdout, QIODevice::WriteOnly);

// ------------------------------------------------------------------------------------------------------------------- //
//    Construction & Destruction                                                                                       //
// ------------------------------------------------------------------------------------------------------------------- //

Configuration::Configuration()
    : ConfigurationBase()
{
    // Add password option
    this->setCurrentGroup("General");
    PasswordItem *item = new PasswordItem("General", "Password", m_password);
    this->addItem(item);
}

// ------------------------------------------------------------------------------------------------------------------- //

Configuration::~Configuration()
{
}


// ------------------------------------------------------------------------------------------------------------------- //
//    Public methods                                                                                                   //
// ------------------------------------------------------------------------------------------------------------------- //

void Configuration::setPassword(const QString &password)
{
    m_password = password;
}

// ------------------------------------------------------------------------------------------------------------------- //

QString Configuration::password() const
{
    return m_password;
}

// ------------------------------------------------------------------------------------------------------------------- //
    
void Configuration::writeConfig()
{
    // Make sure a sound file is given if sound is enabled
    if (this->soundEnabled() && this->soundFile().isEmpty())
        this->setSoundEnabled(false);

    // Same thing for LedOn and LedOff
    if (this->ledEnabled() && (this->ledOnCommand().isEmpty() || this->ledOffCommand().isEmpty()))
        this->setLedEnabled(false);

    // Save on disk
    ConfigurationBase::writeConfig();
}


// ------------------------------------------------------------------------------------------------------------------- //
//    Singleton access                                                                                                 //
// ------------------------------------------------------------------------------------------------------------------- //

Configuration* Configuration::config()
{
    static Configuration config;
    return &config;
}

// ------------------------------------------------------------------------------------------------------------------- //
