#!/usr/bin/env python
# -*- coding: utf-8 -*-

#  _   _______                 _ _ _   _       _   _  __ _
# | | / /  __ \               (_) | \ | |     | | (_)/ _(_)
# | |/ /| |  \/_ __ ___   __ _ _| |  \| | ___ | |_ _| |_ _  ___ _ __
# |    \| | __| '_ ` _ \ / _` | | | . ` |/ _ \| __| |  _| |/ _ \ '__|
# | |\  \ |_\ \ | | | | | (_| | | | |\  | (_) | |_| | | | |  __/ |
# \_| \_/\____/_| |_| |_|\__,_|_|_\_| \_/\___/ \__|_|_| |_|\___|_|

############################################################################
#    Copyright (C) 2007 by Marcel Hasler                                   #
#    mahasler@gmail.com                                                    #
#                                                                          #
#    This program is free software; you can redistribute it and/or modify  #
#    it under the terms of the GNU General Public License version 2        #
#    as published by the Free Software Foundation.                         #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             #
############################################################################

from kdecore import KApplication, KAboutData, KCmdLineArgs, KProcess, KAudioPlayer, KLocale
from kdeui import KAboutApplication
from qt import *
import trayicon
import configurationdialog
import accountmanager
import popupwindow
import configurationhandler
from iconpaths import *
import i18n
import sys
import os
import urllib2

class KGmailNotifier(QWidget):
	def __init__(self, aboutData):
		QWidget.__init__(self)
		
		print "\nWelcome to KGmailNotifier.\n(c) 2007 Marcel Hasler (mahasler@gmail.com)\n\nThis program is released under the terms of the GNU General Public License Version 2.\n\nEnjoy!\n"
		
		
		# Set up language handler and configuration handler/dialog
		self.configurationHandler = configurationhandler.ConfigurationHandler()
		self.languageHandler = i18n.i18n()
		self.languageHandler.SetLanguage(self.configurationHandler.GetLanguage())
		self.itsConfigWindow = configurationdialog.ConfigurationDialog(self.configurationHandler, self.languageHandler)
		self.connect(self.itsConfigWindow,PYSIGNAL("ConfigurationChanged()"),self.ApplyConfiguration)
	
	
		# Add about data
		shortDescription = self.languageHandler.Translate("A Gmail notifier applet for KDE").encode('utf8')
		author = self.languageHandler.Translate("Author and Maintainer").encode('utf8')
		credit = self.languageHandler.Translate("Author of the gmailatom library").encode('utf8')
		credit2 = self.languageHandler.Translate("Author of the pyDes library").encode('utf8')
		aboutData.setShortDescription(shortDescription)
		aboutData.addAuthor("Marcel Hasler",author,"mahasler@gmail.com")
		aboutData.addCredit("Juan Grande",credit,"","http://gmail-notify.sourceforge.net")
		aboutData.addCredit("Todd Whiteman",credit2,"","http://twhiteman.netfirms.com/des.html")
		aboutData.setTranslator("someName","someAddress")
		
		# Add translators
		language1 = "%s (Français)" % self.languageHandler.Translate("Translation").encode('utf8')
		aboutData.addCredit("Charles-Henri d'Adhémar", language1, "cdadhemar@gmail.com")		
		
		language2 = "%s (Español)" % self.languageHandler.Translate("Translation").encode('utf8')
		aboutData.addCredit("Alfredo Amaya", language2, "alfreito@gmail.com")
		
		language3 = "%s (Magyar nyelv)" % self.languageHandler.Translate("Translation").encode('utf8')
		aboutData.addCredit("Peter Avramucz", language3, "muczyjoe@gmail.com")
		
		language4 = "%s (Polski)" % self.languageHandler.Translate("Translation").encode('utf8')
		aboutData.addCredit("Marcin Dryka", language4, "marcin.dryka@gmail.com")
		
		language5 = "%s (Slovenski jezik)" % self.languageHandler.Translate("Translation").encode('utf8')
		aboutData.addCredit("Peter Fajdiga", language5, "peter.fajdiga@gmail.com")		
		
		language6 = "%s (Česky)" % self.languageHandler.Translate("Translation").encode('utf8')
		aboutData.addCredit("Milan Leszkow", language6, "enormoss@gmail.com")
		
		language7 = "%s (Русский)" % self.languageHandler.Translate("Translation").encode('utf8')
		aboutData.addCredit("Eugene Nikiforov", language7, "zzajazz@gmail.com")
		
		language8 = "%s (Italiano)" % self.languageHandler.Translate("Translation").encode('utf8')
		aboutData.addCredit("Daniele Pantoli", language8, "daniele.p88@gmail.com")
		
		language9 = "%s (Slovensky)" % self.languageHandler.Translate("Translation").encode('utf8')
		aboutData.addCredit("Jozef Riha", language9, "jose1711@gmail.com")
		

		# Set up systemtray icon
		self.itsTrayIcon = trayicon.TrayIcon("KGmailNotifier", ICON_SMALL, ICON_RED)
		self.itsTrayIcon.AddItemToMenu(ICON_CHECK,self.languageHandler.Translate("Check mail now"),self.CheckNewMail)
		self.itsTrayIcon.AddItemToMenu(ICON_INBOX,self.languageHandler.Translate("Go to inbox"),self.LaunchBrowser)
		self.itsTrayIcon.AddSeparatorToMenu()
		self.itsTrayIcon.AddItemToMenu(ICON_CONFIGURE,self.languageHandler.Translate("Configure"),self.ShowConfigWindow)
		self.itsTrayIcon.AddItemToMenu(ICON_ABOUT,self.languageHandler.Translate("About KGmailNotifier"),self.ShowAboutWindow)
		self.itsTrayIcon.AddSeparatorToMenu()
		self.itsTrayIcon.AddItemToMenu(ICON_QUIT,self.languageHandler.Translate("Quit"),self.Quit)
		self.itsTrayIcon.SetToolTip(self.languageHandler.Translate("No new messages"))
		self.connect(self.itsTrayIcon,PYSIGNAL("trayIconClicked()"),self.ShowPopupWindow)
		
		
		# If no username or password has been set show configuration dialog
		if self.configurationHandler.GetUsername() == "" or self.configurationHandler.GetPassword() == "":
			self.ShowConfigWindow()
		
		self.accountManager = accountmanager.AccountManager(self.configurationHandler.GetUsername().utf8(),self.configurationHandler.GetPassword().utf8())
		self.accountManager.SetConnectionTimeout(9)
			
		# Set up popup window
		self.itsPopupWindow = popupwindow.PopupWindow(self.configurationHandler.GetHorizontalOffset(), self.configurationHandler.GetVerticalOffset(), self.languageHandler)
		self.itsPopupWindow.SetAnimationDelay(self.configurationHandler.GetAnimationDelay())
		self.itsPopupWindow.SetPopupTimeout(self.configurationHandler.GetPopupTimeout())
		self.itsPopupWindow.SetPopupDirection(self.configurationHandler.GetPopupDirection())
		self.itsPopupWindow.SetAnimationOn(self.configurationHandler.GetPopupAnimated())
		self.connect(self.itsPopupWindow.newMailLabel, SIGNAL("leftClickedURL(const QString&)"), self.LaunchBrowser)
		
		self.itsAboutWindow = KAboutApplication(aboutData,None,"aboutWindow",False)
		
		self.itsAudioPlayer = KAudioPlayer(self.configurationHandler.GetFileToPlay())
		
		# Set timer for checking mail
		self.checkMailTimer = QTimer(self)
		QObject.connect(self.checkMailTimer,SIGNAL("timeout()"),self.CheckNewMail)
		self.checkMailTimer.start(self.configurationHandler.GetCheckInterval() * 1000, False)
		
		if self.configurationHandler.GetLedsEnabled():
			os.system(self.configurationHandler.GetLedOffCommand().ascii())
		self.ledIsOn = False # Avoid calling os.system() needlessly
		self.connectionFailed = False # Only show popup once
		
		# Check for mail
		self.CheckNewMail()


	def ShowConfigWindow(self):
		self.itsConfigWindow.Show()


	def ShowAboutWindow(self):
		self.itsAboutWindow.show()
		
		
	def ShowPopupWindow(self):
		self.itsPopupWindow.Popup()


	def CheckNewMail(self):
		print "Checking for new mail..."
		try:
			self.accountManager.Connect()
			
		except urllib2.URLError:
			errorString = sys.exc_info()[1]
			if errorString.__str__() == "<urlopen error The read operation timed out>":
				errorMessage = "Connection timeout!"
			else:
				errorMessage = "Connection failed!"
			
			print errorMessage
			self.itsTrayIcon.SetIcon(ICON_ALERT)
			self.itsTrayIcon.SetToolTip(self.languageHandler.Translate(errorMessage))
		
			# Show popup only once
			if self.connectionFailed == False:
				print "Showing popup..."
				self.itsPopupWindow.SetConnectionFailed()
				self.ShowPopupWindow()
			
			self.connectionFailed = True
			
		else:
			self.unreadMailCount = self.accountManager.GetUnreadMailCount()
			
			if self.unreadMailCount > 0:
				print "You have %s new message(s)." % self.unreadMailCount
				self.itsTrayIcon.SetIcon(ICON_BLUE)
				self.itsTrayIcon.SetToolTip("%s %s" % (self.unreadMailCount,self.languageHandler.Translate("new message(s)")))
				self.itsPopupWindow.SetUnreadMsgCount(self.unreadMailCount)
				self.itsPopupWindow.SetSenderAddress(self.accountManager.GetLastSenderAddress())
				self.itsPopupWindow.SetMsgTitle(self.accountManager.GetLastMessageTitle())
				
				if self.accountManager.HasNewMail() == True:					
					# Play a sound
					if self.configurationHandler.GetSoundEnabled():
						self.itsAudioPlayer.play()

					# Turn on LED
					if self.configurationHandler.GetLedsEnabled():
						os.system(self.configurationHandler.GetLedOnCommand().ascii())
						self.ledIsOn = True
						
					print "Showing popup..."
					self.ShowPopupWindow()
		
			else:
				print "No new mail."
				self.itsTrayIcon.SetIcon(ICON_RED)
				self.itsTrayIcon.SetToolTip(self.languageHandler.Translate("No new messages"))
				self.itsPopupWindow.SetUnreadMsgCount(0)
				self.itsPopupWindow.SetSenderAddress("")
				self.itsPopupWindow.SetMsgTitle("")
				
				# Turn off LED
				if self.configurationHandler.GetLedsEnabled():
					if self.ledIsOn:
						os.system(self.configurationHandler.GetLedOffCommand().ascii())
						self.ledIsOn = False
			
			# Everything's ok
			self.connectionFailed = False
		


	def ApplyConfiguration(self):
		# Apply what's necessary when configuration has changed
		self.accountManager.UpdateAccount(self.configurationHandler.GetUsername().utf8(),self.configurationHandler.GetPassword().utf8())
		self.checkMailTimer.changeInterval(self.configurationHandler.GetCheckInterval() * 1000)
		self.itsPopupWindow.SetPosition(self.itsConfigWindow.horizontalOffsetSpinBox.value(), self.itsConfigWindow.verticalOffsetSpinBox.value())
		self.itsPopupWindow.SetAnimationDelay(self.configurationHandler.GetAnimationDelay())
		self.itsPopupWindow.SetPopupTimeout(self.configurationHandler.GetPopupTimeout())
		self.itsPopupWindow.SetPopupDirection(self.configurationHandler.GetPopupDirection())
		self.itsPopupWindow.SetAnimationOn(self.configurationHandler.GetPopupAnimated())
		self.itsAudioPlayer = KAudioPlayer(self.configurationHandler.GetFileToPlay())


	def LaunchBrowser(self):
		print "Starting browser..."
		self.browserProc = KProcess()
		self.browserProc.setExecutable(self.configurationHandler.GetBrowserPath())
		self.browserProc.setArguments(["www.gmail.com"])
		self.browserProc.start()


	def Quit(self):
		# With some Python/PyQt/PyKDE combinations the automatic deletion
		# of some of the objects doesn't work correctly, causing a crash.
		# To be sure, we'll destroy them manually.
		del self.itsTrayIcon
		del self.itsConfigWindow
		del self.itsAboutWindow
		del self.itsPopupWindow
		del self.configurationHandler
		del self.languageHandler
		
		print "\nGoodbye!"
		self.close()



def main(app, aboutData):
	kgmailnotifier = KGmailNotifier(aboutData)
	kgmailnotifier.setIcon(QPixmap(ICON_RED))
	app.setMainWidget(kgmailnotifier)
	app.exec_loop()
	
if __name__ == "__main__":
	KLocale.setMainCatalogue("konqueror") # i18n for standard dialogs
	
	aboutData = KAboutData("KGmailNotifier","KGmailNotifier","0.3.1","",1,"Copyright (C) 2007 Marcel Hasler","","","mahasler@gmail.com")
	try:
		aboutData.setProgramLogo(QImage(ICON_RED)) # Old PyKDE versions don't support this function
	except:
		print "\nCouldn't set program logo in about dialog. Your PyKDE version may be outdated. Continuing anyway..."	
	
	KCmdLineArgs.init (sys.argv, aboutData)
	
	app = KApplication()
	main(app, aboutData)
