/*
 *
 *  Kepas - KDE Easy Publish and Share
 *
 *  Copyright (C) 2008  Tom Patzig <tpatzig@suse.de>
 *
 *  This file is part of kepas.
 *
 *  kepas is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  kepas is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with kepas; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
*/

#ifndef SERVCIELOCATOR_H
#define SERVCIELOCATOR_H


#include <QByteArray>
#include <stdlib.h>
//#include <avahi-client/client.h>
//#include <avahi-qt4/qt-watch.h>
//#include <avahi-client/lookup.h>
#include <dnssd/servicebrowser.h>
#include <dnssd/servicebase.h>
#include <dnssd/publicservice.h>
#include <kconfig.h>

#include "receiver.h"

class KDE_EXPORT ServiceLocator : public QObject
{

Q_OBJECT
public:
	 ServiceLocator(QObject* parent = 0);
	 ~ServiceLocator();	 
	 void browse();
	 void httpBrowse();
	 DNSSD::PublicService* service;
	 void startService();

	 Receiver* receiver;
	 void setUserName(QString);
	 QString getUserName();
	 bool restartPublish();

private:

//	 const AvahiPoll* avahiPoll;
//	 AvahiClient* client;
	 DNSSD::ServiceBrowser* browser;
	 DNSSD::ServiceBrowser* httpBrowser;
	 QTcpServer* server;

	 QString hostname;
	 QString username;
	 QTcpSocket*socket;
	 QHttp* http; 
	
	 QMap<QString,QByteArray> serviceID;
	
	 void checkBrowse();
	 bool checkRunStatus;

private slots:

	void addService(DNSSD::RemoteService::Ptr srv);
	void delService(DNSSD::RemoteService::Ptr srv); 
	void addHttpService(DNSSD::RemoteService::Ptr srv);
	void delHttpService(DNSSD::RemoteService::Ptr srv);

	void slotNewConnection();
	void launchReceiver();
	void checkBrowseFinished();

signals:

	void addBuddy(QMap<QString, QByteArray>);
	void delBuddy(QString);
	void httpFound(QString,QString);
	void httpRemoved(QString);
	
	void serviceRuns();

};

#endif
