/*
 *
 *  Kepas - KDE Easy Publish and Share
 *
 *  Copyright (C) 2008  Tom Patzig <tpatzig@suse.de>
 *
 *  This file is part of kepas.
 *
 *  kepas is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  kepas is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with kepas; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
*/

#ifndef SENDER_H
#define SENDER_H


#include <QtNetwork>
#include <QtGui>
#include <KMessageBox>


class Sender : public QWidget
{
Q_OBJECT

public:
	 Sender(QObject* parent,QString llhostname,QString hostname, int port, QString user);
	 ~Sender();
	 
	 void sendFileRequest();
	 void sendClipRequest(QString);
	
	 void initFileSender(QString filename, int count);
	 void initClipSender();

private:
	 QHttpRequestHeader* requestGet;
	 QHttpRequestHeader* requestPost;
	 QHttpRequestHeader* requestPut;
	 QHttp* http;

	 QObject* m_parent;
	 QString m_hostname;
	 QString m_llhostname;
	 int m_port;
	 QString m_user;
	 int m_count;
	 QString m_filename;
	 QFile* file;
	 QProgressDialog* progress;

public slots:
     void slotGetResponseReceived(const QHttpResponseHeader& resp);
     void slotPutResponseReceived(const QHttpResponseHeader& resp);
     void slotTransferProgress(int done, int total);
     void slotTransferCanceled();
     void slotRequestFinished(int, bool);
     void slotTransferFinished(const QHttpResponseHeader&);

signals:
     void transferFinished();
     void transferDenied();

};

#endif
