/*  ksim - a system monitor for kde
 *
 *  Copyright (C) 2001  Robbie Ward <linuxphreak@gmx.co.uk>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef NETDIALOG_H
#define NETDIALOG_H

#include <q3tabdialog.h>
//Added by qt3to4:
#include <Q3VBoxLayout>
#include <QLabel>
#include <Q3GridLayout>

class Q3VBoxLayout;
class Q3GridLayout;
class QCheckBox;
class Q3GroupBox;
class QLabel;
class QWidget;
class KComboBox;
class KLineEdit;
class KUrlRequester;

class NetDialog : public Q3TabDialog
{
  Q_OBJECT
  public:
    NetDialog(QWidget *parent, const char *name = 0);
    ~NetDialog();

    const QString deviceName() const;
    bool timer();
    const QString format() const;
    bool commands();
    const QString cCommand() const;
    const QString dCommand() const;
    bool okClicked() { return m_clicked; }

  public slots:
    void setDeviceName(const QString &);
    void setShowTimer(bool);
    void setFormat(const QString &);
    void setShowCommands(bool);
    void setCCommand(const QString &);
    void setDCommand(const QString &);

  private slots:
    void sendClicked();

  private:
    QStringList createList() const;

    bool m_clicked;
    QWidget *m_generalTab;
    QLabel *m_deviceLabel;
    KComboBox *m_deviceCombo;
    Q3GroupBox *m_timerBox;
    QCheckBox *m_showTimer;
    KLineEdit *m_timerEdit;
    QLabel *m_hFormat;
    QLabel *m_mFormat;
    QLabel *m_sFormat;
    QWidget *m_commandTab;
    QCheckBox *m_enableCommands;
    QLabel *m_cCommand;
    KUrlRequester *m_connectRequester;
    QLabel *m_dCommand;
    KUrlRequester *m_disconnectRequester;

    Q3GridLayout *m_generalLayout;
    Q3VBoxLayout *m_timerBoxLayout;
    Q3GridLayout *m_commandLayout;
};
#endif // NETDIALOG_H
