/***************************************************************************
                           DScalerFilterTomsmocomp.h
                           -------------------------
    begin                : Sat Jul 10 2004
    copyright            : (C) 2004 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
***************************************************************************/

/*
 * TomsMoComp algorithm taken from DScaler.
 * Copyright (c) 2002 Tom Barry.  All rights reserved.
 *
 * Ported by: Dirk Ziegelmeier
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 */

#ifndef DSCALERFILTERTOMSMOCOMP_H
#define DSCALERFILTERTOMSMOCOMP_H

#include <kdetvdscalerfilter.h>

#define SEARCHEFFORT_DEFAULT  5
#define USESTRANGEBOB_DEFAULT false

class DScalerFilterTomsMoComp : public KdetvDScalerFilter
{
public:
    DScalerFilterTomsMoComp();
    virtual ~DScalerFilterTomsMoComp();

    virtual void filterDScaler_3DNOW(TDeinterlaceInfo* pInfo);
    virtual void filterDScaler_MMX(TDeinterlaceInfo* pInfo);
    virtual void filterDScaler_SSE(TDeinterlaceInfo* pInfo);

    long SearchEffort;
    bool UseStrangeBob;

private:
    int Fieldcopy(void *dest, const void *src, size_t count,
                  int rows, int dst_pitch, int src_pitch);

    MEMCPY_FUNC* pMyMemcpy;
    bool IsOdd;
    const unsigned char* pWeaveSrc;
    const unsigned char* pWeaveSrcP;
    unsigned char* pWeaveDest;
    const unsigned char* pCopySrc;
    const unsigned char* pCopySrcP;
    unsigned char* pCopyDest;
    int src_pitch;
    int dst_pitch;
    int rowsize;
    int height;
    int FldHeight;

    int Search_Effort_MMX_0();
    int Search_Effort_MMX_1();
    int Search_Effort_MMX_3();
    int Search_Effort_MMX_5();
    int Search_Effort_MMX_9();
    int Search_Effort_MMX_11();
    int Search_Effort_MMX_13();
    int Search_Effort_MMX_15();
    int Search_Effort_MMX_19();
    int Search_Effort_MMX_21();
    int Search_Effort_MMX_Max();

    int Search_Effort_SSE_0();
    int Search_Effort_SSE_1();
    int Search_Effort_SSE_3();
    int Search_Effort_SSE_5();
    int Search_Effort_SSE_9();
    int Search_Effort_SSE_11();
    int Search_Effort_SSE_13();
    int Search_Effort_SSE_15();
    int Search_Effort_SSE_19();
    int Search_Effort_SSE_21();
    int Search_Effort_SSE_Max();

    int Search_Effort_3DNOW_0();
    int Search_Effort_3DNOW_1();
    int Search_Effort_3DNOW_3();
    int Search_Effort_3DNOW_5();
    int Search_Effort_3DNOW_9();
    int Search_Effort_3DNOW_11();
    int Search_Effort_3DNOW_13();
    int Search_Effort_3DNOW_15();
    int Search_Effort_3DNOW_19();
    int Search_Effort_3DNOW_21();
    int Search_Effort_3DNOW_Max();

    int Search_Effort_MMX_0_SB();
    int Search_Effort_MMX_1_SB();
    int Search_Effort_MMX_3_SB();
    int Search_Effort_MMX_5_SB();
    int Search_Effort_MMX_9_SB();
    int Search_Effort_MMX_11_SB();
    int Search_Effort_MMX_13_SB();
    int Search_Effort_MMX_15_SB();
    int Search_Effort_MMX_19_SB();
    int Search_Effort_MMX_21_SB();
    int Search_Effort_MMX_Max_SB();

    int Search_Effort_SSE_0_SB();
    int Search_Effort_SSE_1_SB();
    int Search_Effort_SSE_3_SB();
    int Search_Effort_SSE_5_SB();
    int Search_Effort_SSE_9_SB();
    int Search_Effort_SSE_11_SB();
    int Search_Effort_SSE_13_SB();
    int Search_Effort_SSE_15_SB();
    int Search_Effort_SSE_19_SB();
    int Search_Effort_SSE_21_SB();
    int Search_Effort_SSE_Max_SB();

    int Search_Effort_3DNOW_0_SB();
    int Search_Effort_3DNOW_1_SB();
    int Search_Effort_3DNOW_3_SB();
    int Search_Effort_3DNOW_5_SB();
    int Search_Effort_3DNOW_9_SB();
    int Search_Effort_3DNOW_11_SB();
    int Search_Effort_3DNOW_13_SB();
    int Search_Effort_3DNOW_15_SB();
    int Search_Effort_3DNOW_19_SB();
    int Search_Effort_3DNOW_21_SB();
    int Search_Effort_3DNOW_Max_SB();
};

#endif
