/*
 *
 * Copyright (C) 2002 George Staikos <staikos@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _CFGDATA_H
#define _CFGDATA_H

#include <qstring.h>

// Aspect ratio algorithms:
#define AR_HEIGHT_TO_WIDTH 0
#define AR_WIDTH_TO_HEIGHT 1
#define AR_BEST_FIT        2

// Capture sizes:
struct grab_resolutions_s {
    int w, h;
    const char* name;
};
extern struct grab_resolutions_s grab_resolutions[];


class KConfig;

/**
 * Global configuration data.
 *
 * The config system is prepared to save some settings globally for all
 * clients that use libkdetv. At present, the feature is unused, but
 * maybe it comes in handy in the future. The real problem is the UI,
 * though. Should the user be bothered with "this applies to all apps
 * that use libkdetv backend"???
 */
 
class ConfigData
{
public:
    /**
     * Returns reference to a config object containing default settings
     */
    static const ConfigData& getDefaultConfig();

    /** Destructor */
    ~ConfigData();
    
    /** Copy operator */
    ConfigData const &operator=(ConfigData const &);

    void defaults();
    
    int save();
    int load();

    int loadDeviceSettings(const QString& dev);
    int saveDeviceSettings(const QString& dev);

    KConfig* backendConfigHandle() const { return _backendCfg; };
    KConfig* clientConfigHandle()  const { return _clientCfg;  };
    KConfig* pluginConfigHandle()  const { return _clientCfg;  };


protected:
    int saveBackendSettings();
    int saveClientSettings();

    int loadBackendSettings();
    int loadClientSettings();
    

public:
    bool firstTime;

    bool showSelectedOnly;
    int  channelNumberingStart;
    int  maxKeypressInterval;
    bool mouseWheelUpIsChUp;

    bool fixAR;
    int  ARmode;

    QString snapshotPath;
    QString snapshotFormat;
    int snapshotQuality;
    int snapshotRes;

    QString channelFile;
    
    QString prevDev;
    int lastChannel;
    
    // Volume Related Settings
    bool volumeMuted;
    int  volumeLeft;
    int  volumeRight;
    int  volumeRestoreDelay;   
    int  volumeIncrement;
    bool autoMute;
    bool volumeControlViaSoundCard;
    int  tvCardVolume;
    int  mixerVolume;

private:
    friend class Kdetv;
    ConfigData(KConfig* backendCfg, KConfig* clientCfg);

    KConfig* _backendCfg;    
    KConfig* _clientCfg;    
};


#endif
