//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {

	using System;
	using Qyoto;
	using System.Collections.Generic;

	public interface IKFileView {
		void AddItemList(List<KFileItem> list);
		QWidget Widget();
		void SetCurrentItem(string filename);
		void SetCurrentItem(KFileItem item);
		KFileItem CurrentFileItem();
		void Clear();
		void UpdateView(bool f);
		void UpdateView();
		void UpdateView(KFileItem arg1);
		void RemoveItem(KFileItem item);
		void ListingCompleted();
		uint Sorting();
		void SetSorting(uint sort);
		bool IsReversed();
		void SortReversed();
		uint Count();
		uint NumFiles();
		uint NumDirs();
		void SetSelectionMode(int sm);
		void SetViewMode(KFileView.ViewMode vm);
		KFileView.ViewMode viewMode();
		string ViewName();
		void SetViewName(string name);
		void SetParentView(KFileView parent);
		void InsertItem(KFileItem i);
		void ClearView();
		void EnsureItemVisible(KFileItem i);
		void ClearSelection();
		void SelectAll();
		void InvertSelection();
		void SetSelected(KFileItem arg1, bool enable);
		bool IsSelected(KFileItem arg1);
		List<KFileItem> SelectedItems();
		List<KFileItem> Items();
		KFileItem FirstFileItem();
		KFileItem NextItem(KFileItem arg1);
		KFileItem PrevItem(KFileItem arg1);
		void SetOnlyDoubleClickSelectsFiles(bool enable);
		bool OnlyDoubleClickSelectsFiles();
		bool UpdateNumbers(KFileItem i);
		KActionCollection ActionCollection();
		KFileViewSignaler Signaler();
		void ReadConfig(KConfigGroup arg1);
		void WriteConfig(KConfigGroup arg1);
		void SetDropOptions(int options);
		int dropOptions();
	}

	/// <remarks>
	///  This class defines an interface to all file views. Its intent is
	///  to allow to switch the view of the files in the selector very easily.
	///  It defines some pure functions, that must be implemented to
	///  make a file view working.
	///  Since this class is not a widget, but it's meant to be added to other
	///  widgets, its most important function is widget. This should return
	///  a pointer to the implemented widget.
	/// </remarks>		<author> Stephan Kulow <coolo@kde.org>
	/// </author>
	/// 		<short> A base class for views of the KDE file selector.</short>

	[SmokeClass("KFileView")]
	public abstract class KFileView : Object, IKFileView {
		protected SmokeInvocation interceptor = null;
		private IntPtr smokeObject;
		protected KFileView(Type dummy) {}
		protected void CreateProxy() {
			interceptor = new SmokeInvocation(typeof(KFileView), this);
		}
		private static SmokeInvocation staticInterceptor = null;
		static KFileView() {
			staticInterceptor = new SmokeInvocation(typeof(KFileView), null);
		}
		public enum ViewMode {
			Files = 1,
			Directories = 2,
			All = Files|Directories,
		}
		/// <remarks>
		///  Various options for drag and drop support.
		///  These values can be or'd together.
		/// 
		/// <li>
		/// <code>AutoOpenDirs</code> Automatically open directory after hovering above it
		///  for a short while while dragging.
		///      
		/// </li></remarks>		<short>    Various options for drag and drop support.</short>
		public enum DropOptions {
			AutoOpenDirs = 1,
		}
		// QString sortingKey(KIO::filesize_t arg1,bool arg2,QDir::SortFlags arg3); >>>> NOT CONVERTED
		/// <remarks>
		///  Creates a new file view.
		///      </remarks>		<short>    Creates a new file view.</short>
		public KFileView() : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KFileView", "KFileView()", typeof(void));
		}
		/// <remarks>
		///  Inserts a list of items.
		/// </remarks>		<short>    Inserts a list of items.</short>
		public void AddItemList(List<KFileItem> list) {
			interceptor.Invoke("addItemList#", "addItemList(const KFileItemList&)", typeof(void), typeof(List<KFileItem>), list);
		}
		/// <remarks>
		///  a pure function to get a QWidget, that can be added to
		///  other widgets. This function is needed to make it possible for
		///  derived classes to derive from other widgets.
		/// </remarks>		<short>    a pure virtual function to get a QWidget, that can be added to  other widgets.</short>
		[SmokeMethod("widget()")]
		public abstract QWidget Widget();
		/// <remarks>
		///  Sets <code>filename</code> the current item in the view, if available.
		///      </remarks>		<short>    Sets <code>filename</code> the current item in the view, if available.</short>
		public void SetCurrentItem(string filename) {
			interceptor.Invoke("setCurrentItem$", "setCurrentItem(const QString&)", typeof(void), typeof(string), filename);
		}
		/// <remarks>
		///  Reimplement this to set <code>item</code> the current item in the view, e.g.
		///  the item having focus.
		///      </remarks>		<short>    Reimplement this to set <code>item</code> the current item in the view, e.</short>
		[SmokeMethod("setCurrentItem(const KFileItem&)")]
		public abstract void SetCurrentItem(KFileItem item);
		/// <remarks>
		/// </remarks>		<return> the "current" KFileItem, e.g. where the cursor is.
		///  Returns an null file item when there is no current item (e.g. in an empty view).
		///  Subclasses have to implement this.
		///      </return>
		/// 		<short>   </short>
		[SmokeMethod("currentFileItem() const")]
		public abstract KFileItem CurrentFileItem();
		/// <remarks>
		///  Clears the view and all item lists.
		///      </remarks>		<short>    Clears the view and all item lists.</short>
		[SmokeMethod("clear()")]
		public virtual void Clear() {
			interceptor.Invoke("clear", "clear()", typeof(void));
		}
		/// <remarks>
		///  does a repaint of the view.
		///  The default implementation calls
		///  <pre>
		///  widget().Repaint(f)
		///  </pre>
		/// </remarks>		<short>    does a repaint of the view.</short>
		[SmokeMethod("updateView(bool)")]
		public virtual void UpdateView(bool f) {
			interceptor.Invoke("updateView$", "updateView(bool)", typeof(void), typeof(bool), f);
		}
		[SmokeMethod("updateView()")]
		public virtual void UpdateView() {
			interceptor.Invoke("updateView", "updateView()", typeof(void));
		}
		[SmokeMethod("updateView(const KFileItem&)")]
		public virtual void UpdateView(KFileItem arg1) {
			interceptor.Invoke("updateView#", "updateView(const KFileItem&)", typeof(void), typeof(KFileItem), arg1);
		}
		/// <remarks>
		///  Removes an item from the list; has to be implemented by the view.
		///  Call KFileView.RemoveItem( item ) after removing it.
		///      </remarks>		<short>    Removes an item from the list; has to be implemented by the view.</short>
		[SmokeMethod("removeItem(const KFileItem&)")]
		public virtual void RemoveItem(KFileItem item) {
			interceptor.Invoke("removeItem#", "removeItem(const KFileItem&)", typeof(void), typeof(KFileItem), item);
		}
		/// <remarks>
		///  This hook is called when all items of the currently listed directory
		///  are listed and inserted into the view, i.e. there won't come any new
		///  items anymore.
		///      </remarks>		<short>    This hook is called when all items of the currently listed directory  are listed and inserted into the view, i.</short>
		[SmokeMethod("listingCompleted()")]
		public virtual void ListingCompleted() {
			interceptor.Invoke("listingCompleted", "listingCompleted()", typeof(void));
		}
		/// <remarks>
		///  Returns the sorting order of the internal list. Newly added files
		///  are added through this sorting.
		///       </remarks>		<short>    Returns the sorting order of the internal list.</short>
		public uint Sorting() {
			return (uint) interceptor.Invoke("sorting", "sorting() const", typeof(uint));
		}
		/// <remarks>
		///  Sets the sorting order of the view.
		///  Default is QDir.Name | QDir.IgnoreCase | QDir.DirsFirst
		///  Override this in your subclass and sort accordingly (usually by
		///  setting the sorting-key for every item and telling QIconView
		///  or QListView to sort.
		///  A view may choose to use a different sorting than QDir.Name, Time
		///  or Size. E.g. to sort by mimetype or any possible string. Set the
		///  sorting to QDir.Unsorted for that and do the rest internally.
		/// </remarks>		<short>    Sets the sorting order of the view.</short>
		/// 		<see> sortingKey</see>
		[SmokeMethod("setSorting(QDir::SortFlags)")]
		public virtual void SetSorting(uint sort) {
			interceptor.Invoke("setSorting$", "setSorting(QDir::SortFlags)", typeof(void), typeof(uint), sort);
		}
		/// <remarks>
		///  Tells whether the current items are in reversed order (shortcut to
		///  sorting() & QDir.Reversed).
		///      </remarks>		<short>    Tells whether the current items are in reversed order (shortcut to  sorting() & QDir.Reversed).</short>
		public bool IsReversed() {
			return (bool) interceptor.Invoke("isReversed", "isReversed() const", typeof(bool));
		}
		public void SortReversed() {
			interceptor.Invoke("sortReversed", "sortReversed()", typeof(void));
		}
		/// <remarks>
		/// </remarks>		<return> the number of dirs and files
		/// </return>
		/// 		<short>   </short>
		public uint Count() {
			return (uint) interceptor.Invoke("count", "count() const", typeof(uint));
		}
		/// <remarks>
		/// </remarks>		<return> the number of files.
		/// </return>
		/// 		<short>   </short>
		public uint NumFiles() {
			return (uint) interceptor.Invoke("numFiles", "numFiles() const", typeof(uint));
		}
		/// <remarks>
		/// </remarks>		<return> the number of directories
		/// </return>
		/// 		<short>   </short>
		public uint NumDirs() {
			return (uint) interceptor.Invoke("numDirs", "numDirs() const", typeof(uint));
		}
		[SmokeMethod("setSelectionMode(KFile::SelectionMode)")]
		public virtual void SetSelectionMode(int sm) {
			interceptor.Invoke("setSelectionMode?", "setSelectionMode(KFile::SelectionMode)", typeof(void), typeof(int), sm);
		}
		[SmokeMethod("setViewMode(KFileView::ViewMode)")]
		public virtual void SetViewMode(KFileView.ViewMode vm) {
			interceptor.Invoke("setViewMode$", "setViewMode(KFileView::ViewMode)", typeof(void), typeof(KFileView.ViewMode), vm);
		}
		[SmokeMethod("viewMode() const")]
		public virtual KFileView.ViewMode viewMode() {
			return (KFileView.ViewMode) interceptor.Invoke("viewMode", "viewMode() const", typeof(KFileView.ViewMode));
		}
		/// <remarks>
		/// </remarks>		<return> the localized name of the view, which could be displayed
		///  somewhere, e.g. in a menu, where the user can choose between views.
		/// </return>
		/// 		<short>   </short>
		/// 		<see> setViewName</see>
		public string ViewName() {
			return (string) interceptor.Invoke("viewName", "viewName() const", typeof(string));
		}
		/// <remarks>
		///  Sets the name of the view, which could be displayed somewhere.
		///  E.g. "Image Preview".
		///      </remarks>		<short>    Sets the name of the view, which could be displayed somewhere.</short>
		public void SetViewName(string name) {
			interceptor.Invoke("setViewName$", "setViewName(const QString&)", typeof(void), typeof(string), name);
		}
		[SmokeMethod("setParentView(KFileView*)")]
		public virtual void SetParentView(KFileView parent) {
			interceptor.Invoke("setParentView#", "setParentView(KFileView*)", typeof(void), typeof(KFileView), parent);
		}
		/// <remarks>
		///  The derived view must implement this function to add
		///  the file in the widget.
		///  Make sure to call this implementation, i.e.
		///  KFileView.InsertItem( i );
		///      </remarks>		<short>    The derived view must implement this function to add  the file in the widget.</short>
		[SmokeMethod("insertItem(const KFileItem&)")]
		public virtual void InsertItem(KFileItem i) {
			interceptor.Invoke("insertItem#", "insertItem(const KFileItem&)", typeof(void), typeof(KFileItem), i);
		}
		/// <remarks>
		///  pure function, that should be implemented to clear
		///  the view. At this moment the list is already empty
		/// </remarks>		<short>    pure virtual function, that should be implemented to clear  the view.</short>
		[SmokeMethod("clearView()")]
		public abstract void ClearView();
		/// <remarks>
		///  pure function, that should be implemented to make item i
		///  visible, i.e. by scrolling the view appropriately.
		///      </remarks>		<short>    pure virtual function, that should be implemented to make item i  visible, i.</short>
		[SmokeMethod("ensureItemVisible(const KFileItem&)")]
		public abstract void EnsureItemVisible(KFileItem i);
		/// <remarks>
		///  Clears any selection, unhighlights everything. Must be implemented by
		///  the view.
		///      </remarks>		<short>    Clears any selection, unhighlights everything.</short>
		[SmokeMethod("clearSelection()")]
		public abstract void ClearSelection();
		/// <remarks>
		///  Selects all items. You may want to override this, if you can implement
		///  it more efficiently than calling setSelected() with every item.
		///  This works only in Multiselection mode of course.
		///      </remarks>		<short>    Selects all items.</short>
		[SmokeMethod("selectAll()")]
		public virtual void SelectAll() {
			interceptor.Invoke("selectAll", "selectAll()", typeof(void));
		}
		/// <remarks>
		///  Inverts the current selection, i.e. selects all items, that were up to
		///  now not selected and deselects the other.
		///      </remarks>		<short>    Inverts the current selection, i.</short>
		[SmokeMethod("invertSelection()")]
		public virtual void InvertSelection() {
			interceptor.Invoke("invertSelection", "invertSelection()", typeof(void));
		}
		/// <remarks>
		///  Tells the view that it should highlight the item.
		///  This function must be implemented by the view.
		/// </remarks>		<short>    Tells the view that it should highlight the item.</short>
		[SmokeMethod("setSelected(const KFileItem&, bool)")]
		public abstract void SetSelected(KFileItem arg1, bool enable);
		/// <remarks>
		/// </remarks>		<return> whether the given item is currently selected.
		///  Must be implemented by the view.
		///      </return>
		/// 		<short>   </short>
		[SmokeMethod("isSelected(const KFileItem&) const")]
		public abstract bool IsSelected(KFileItem arg1);
		/// <remarks>
		/// </remarks>		<return> all currently highlighted items.
		///      </return>
		/// 		<short>   </short>
		public List<KFileItem> SelectedItems() {
			return (List<KFileItem>) interceptor.Invoke("selectedItems", "selectedItems() const", typeof(List<KFileItem>));
		}
		/// <remarks>
		/// </remarks>		<return> all items currently available in the current sort-order
		///      </return>
		/// 		<short>   </short>
		public List<KFileItem> Items() {
			return (List<KFileItem>) interceptor.Invoke("items", "items() const", typeof(List<KFileItem>));
		}
		[SmokeMethod("firstFileItem() const")]
		public abstract KFileItem FirstFileItem();
		[SmokeMethod("nextItem(const KFileItem&) const")]
		public abstract KFileItem NextItem(KFileItem arg1);
		[SmokeMethod("prevItem(const KFileItem&) const")]
		public abstract KFileItem PrevItem(KFileItem arg1);
		/// <remarks>
		///  This is a KFileDialog specific hack: we want to select directories with
		///  single click, but not files. But as a generic class, we have to be able
		///  to select files on single click as well.
		///  This gives us the opportunity to do both.
		///  Every view has to decide when to call select( item ) when a file was
		///  single-clicked, based on onlyDoubleClickSelectsFiles().
		///      </remarks>		<short>    This is a KFileDialog specific hack: we want to select directories with  single click, but not files.</short>
		public void SetOnlyDoubleClickSelectsFiles(bool enable) {
			interceptor.Invoke("setOnlyDoubleClickSelectsFiles$", "setOnlyDoubleClickSelectsFiles(bool)", typeof(void), typeof(bool), enable);
		}
		/// <remarks>
		/// </remarks>		<return> whether files (not directories) should only be select()ed by
		///  double-clicks.
		/// </return>
		/// 		<short>   </short>
		/// 		<see> setOnlyDoubleClickSelectsFiles</see>
		public bool OnlyDoubleClickSelectsFiles() {
			return (bool) interceptor.Invoke("onlyDoubleClickSelectsFiles", "onlyDoubleClickSelectsFiles() const", typeof(bool));
		}
		/// <remarks>
		///  increases the number of dirs and files.
		/// </remarks>		<return> true if the item fits the view mode
		///      </return>
		/// 		<short>    increases the number of dirs and files.</short>
		public bool UpdateNumbers(KFileItem i) {
			return (bool) interceptor.Invoke("updateNumbers#", "updateNumbers(const KFileItem&)", typeof(bool), typeof(KFileItem), i);
		}
		/// <remarks>
		/// </remarks>		<return> the view-specific action-collection. Every view should
		///  add its actions here (if it has any) to make them available to
		///  e.g. the KDirOperator's popup-menu.
		///      </return>
		/// 		<short>   </short>
		[SmokeMethod("actionCollection() const")]
		public virtual KActionCollection ActionCollection() {
			return (KActionCollection) interceptor.Invoke("actionCollection", "actionCollection() const", typeof(KActionCollection));
		}
		public KFileViewSignaler Signaler() {
			return (KFileViewSignaler) interceptor.Invoke("signaler", "signaler() const", typeof(KFileViewSignaler));
		}
		[SmokeMethod("readConfig(KConfigGroup*)")]
		public virtual void ReadConfig(KConfigGroup arg1) {
			interceptor.Invoke("readConfig#", "readConfig(KConfigGroup*)", typeof(void), typeof(KConfigGroup), arg1);
		}
		[SmokeMethod("writeConfig(KConfigGroup*)")]
		public virtual void WriteConfig(KConfigGroup arg1) {
			interceptor.Invoke("writeConfig#", "writeConfig(KConfigGroup*)", typeof(void), typeof(KConfigGroup), arg1);
		}
		/// <remarks>
		///  Specify DND options. See DropOptions for details.
		///  All options are disabled by default.
		///      </remarks>		<short>    Specify DND options.</short>
		[SmokeMethod("setDropOptions(int)")]
		public virtual void SetDropOptions(int options) {
			interceptor.Invoke("setDropOptions$", "setDropOptions(int)", typeof(void), typeof(int), options);
		}
		/// <remarks>
		///  Returns the DND options in effect.
		///  See DropOptions for details.
		///      </remarks>		<short>    Returns the DND options in effect.</short>
		public int dropOptions() {
			return (int) interceptor.Invoke("dropOptions", "dropOptions()", typeof(int));
		}
		/// <remarks>
		///  This method calculates a string from the given parameters, that is
		///  suitable for sorting with e.g. QIconView or QListView. Their
		///  Item-classes usually have a setKey( string ) method or a virtual
		///  method string key() that is used for sorting.
		/// <param> name="value" Any string that should be used as sort criterion
		/// </param><param> name="isDir" Tells whether the key is computed for an item representing
		///               a directory (directories are usually sorted before files)
		/// </param><param> name="SortFlags" An ORed combination of QDir.SortFlag flags.
		///                   Currently, the values IgnoreCase, Reversed and
		///                   DirsFirst are taken into account.
		///      </param></remarks>		<short>    This method calculates a string from the given parameters, that is  suitable for sorting with e.</short>
		public static string SortingKey(string value, bool isDir, uint SortFlags) {
			return (string) staticInterceptor.Invoke("sortingKey$$$", "sortingKey(const QString&, bool, QDir::SortFlags)", typeof(string), typeof(string), value, typeof(bool), isDir, typeof(uint), SortFlags);
		}
		/// <remarks>
		///  An overloaded method that takes not a string, but a number as sort
		///  criterion. You can use this for file-sizes or dates/times for example.
		///  If you use a time_t, you need to cast that to KIO.Filesize_t because
		///  of ambiguity problems.
		///      </remarks>		<short>    An overloaded method that takes not a string, but a number as sort  criterion.</short>
		/// <remarks>
		///  delay before auto opening a directory
		///      </remarks>		<short>   </short>
		public static int AutoOpenDelay() {
			return (int) staticInterceptor.Invoke("autoOpenDelay", "autoOpenDelay()", typeof(int));
		}
	}
}
