/***************************************************************************
 *                                                                         *
 *   copyright (C) 2004, 2005  by Michael Buesch                           *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#ifndef PWMANAGER_MASTERKEY_SMARTKEYBACKEND_H_
#define PWMANAGER_MASTERKEY_SMARTKEYBACKEND_H_

#include <qobject.h>
#include <qthread.h>
#include <qcstring.h>


/** open timeout in seconds */
#define CARD_OPEN_TIMEOUT	30
/** begin reading/writing the card at this offset. */
#define CARD_BEGIN_OFFSET	30


class SmartKey;
class WaitWnd;
class ThreadIpcHost;
class ThreadIpcClient;
class ChipcardInterface;


class SmartKey_backend_ : public QThread
			, public QObject
{
	friend class SmartKey_backend;

protected:
	SmartKey_backend_() { }
};

class SmartKey_backend : public SmartKey_backend_
{
	Q_OBJECT

public:
	enum Task
	{
		task_none,
		task_cancel,

		task_read,
		task_write,
		task_erase
	};
	enum Status
	{
		status_none,
		status_running,
		status_cancel,

		status_ok,
		status_errNoMem,
		status_errOpen,
		status_errTimeout,
		status_errRead,
		status_errWrite,
		status_err2small
	};

public:
	SmartKey_backend(SmartKey *_sk);
	~SmartKey_backend();

	Status writeCard(const QByteArray &data);
	Status readCard(QByteArray *data);
	Status eraseCard();

public slots:
	void cancel();

protected:
	/** overload start(). */
	void start(Priority priority = InheritPriority);
	/** fire up the thread and wait for the result. */
	Status fireUp();
	/** sit back and relax for a while. */
	void relax();
	/** thread worker function. */
	void run();
	/** Get an instance of the chipcard interface. */
	ChipcardInterface * getChipcardInterface() const;

protected slots:
	/** new IPC message received from the thread. */
	void threadMessage(const QByteArray &msg);

protected:
	/** parent. */
	SmartKey *sk;
	/** wait window for opening the card. */
	WaitWnd *openWaitWnd;
	/** wait window progress counter. */
	unsigned int openWaitWndCnt;
	/** wait window for accessing the card. */
	WaitWnd *accessWaitWnd;
	/** host IPC message queue. */
	ThreadIpcHost *hostIpc;
};

class ChipcardInterface
{
public:
	ChipcardInterface() { }
	virtual ~ChipcardInterface() { }

	/** write data to the card. */
	virtual SmartKey_backend::Status write(const QByteArray &data) = 0;
	/** read data from the card. */
	virtual SmartKey_backend::Status read(QByteArray *data) = 0;
	/** erase the card. */
	virtual SmartKey_backend::Status erase() = 0;

protected:
	/** Did the user cancel the operation?
	  * Check this, when waiting for the chipcard.
	  */
	bool isUserCancel() const;
	/** Show/Hide the "Please insert a chipcard" window. */
	void showOpenWindow(bool show) const;
	/** Progress the timeout on the "open window". */
	void openWindowProgress() const;
	/** Show/Hide the "Accessing chipcard" window. */
	void showAccessWindow(bool show) const;
};

#endif // PWMANAGER_MASTERKEY_SMARTKEYBACKEND_H_
