/***************************************************************************
 *   Copyright (C) 2006 by Rohan McGovern                                  *
 *   rohan.pm@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _KDBUS_H_
#define _KDBUS_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kmainwindow.h>

class KListView;
class KStatusBar;
class KTabWidget;

/**
 * Main window.
 */
class kdbus : public KMainWindow
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    kdbus();

    ~kdbus();

    /**
     * Whether or not we should reload all services when a service
     * enters or leaves the bus.
     */
    bool reloadOnServiceChange() const;

private slots:
    /**
     * Refresh all our knowledge of D-BUS services on the currently viewed bus.
     */
    void reload();

    /**
     * Toggle whether or not we should automatically reload D-BUS services
     * when a new service becomes available or an existing service is
     * removed from the bus.
     */
    void toggleReload();

private:
    class Private; Private * d;

    /// Not implemented.
    kdbus( kdbus const & other );

    /// Not implemented.
    const kdbus & operator=( kdbus const & other );
};

#endif // _KDBUS_H_
