/***************************************************************************
 *   Copyright (C) 2006 by Rohan McGovern                                  *
 *   rohan.pm@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "dbusmethodorsignal.h"
#include "dbusmethodargument.h"
#include "dbusinterface.h"

#include <kdebug.h>
#include <klocale.h>

DBusMethodOrSignal::DBusMethodOrSignal(
  QListViewItem * parent,
  QDomElement const & elem,
  QString const & type
) throw( QDBusXmlError )
  : DBusAnnotatable( parent, "(unknown)", type )
{
    m_args.setAutoDelete( true );

    ensureElementIsNamed( elem, type.lower() );
    ensureElementHasAttribute( elem, "name" );

    m_name = elem.attribute( "name" );

    // Is it permissible to have empty signals or methods... ?
    // We'll assume it is...
    if ( !elem.hasChildNodes() ) {
        m_signature = m_name + "()";
    }
    else {
        // Now look for arguments or annotations.
        QDomElement child = elem.firstChild().toElement();

        do {
            if ( child.tagName() == "arg" )
                m_args.append( new DBusMethodArgument( child ) );
            else if ( child.tagName() == "annotation" )
                addAnnotation( child );
            else
                kdWarning() << "Unhandled node in introspect data: "
                            << child.tagName() << endl;
            child = child.nextSibling().toElement();
        } while ( !child.isNull() );

        m_signature = discoverSignature();
    }

    setText(0, m_signature);

    m_object = discoverObject();
    m_service = discoverService();
    m_interface = discoverInterface();
}

QString DBusMethodOrSignal::discoverSignature() const {
    QString signature = m_name + "( ";
    QPtrList< DBusMethodArgument > args = m_args;
    for ( unsigned int i = 0; i < args.count(); i++ ) {
        signature += args.at(i)->direction() + " ";
        signature += args.at(i)->niceType();
        if ( !args.at(i)->name().isNull() )
            signature += " " + args.at(i)->name();
        if ( i != (args.count() - 1) )
            signature += ", ";
    }
    signature += " )";
    return signature;
}

QString DBusMethodOrSignal::name() const {
    return m_name;
}

QString DBusMethodOrSignal::signature() const {
    return m_signature;
}


DBusMethodOrSignal::~DBusMethodOrSignal() {
}
