/***************************************************************************
 *   Copyright (C) 2006 by Rohan McGovern                                  *
 *   rohan.pm@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "dbusinterface.h"
#include "dbussignal.h"
#include "dbusmethod.h"
#include "dbusproperty.h"

#include <kdebug.h>
#include <klocale.h>

#include <qvbox.h>
#include <qlabel.h>

DBusInterface::DBusInterface(
  QListViewItem * parent,
  QDomElement const & elem
) throw ( QDBusXmlError )
 : DBusAnnotatable( parent, "(unknown interface)", "Interface" )
{
    ensureElementIsNamed( elem, "interface" );
    ensureElementHasAttribute( elem, "name" );


    m_interface = elem.attribute( "name" );
    m_service = discoverService();
    m_object = discoverObject();
    setText( 0, m_interface );

    // Is it permissible to have empty interfaces... ?  We'll assume it is...
    if ( !elem.hasChildNodes() )
        return;

    // Now iterate through self, enumerating methods, signals and properties.
    QDomElement child = elem.firstChild().toElement();

    try {
        do {
            if ( child.tagName() == "method" )
                new DBusMethod( this, child );
            else if ( child.tagName() == "signal" )
                new DBusSignal( this, child );
            else if ( child.tagName() == "property" )
                new DBusProperty( this, child );
            else if ( child.tagName() == "annotation" )
                addAnnotation( child );
            else
                kdWarning() << "Unhandled node in introspect data: "
                            << child.tagName() << endl;
            child = child.nextSibling().toElement();
        } while ( !child.isNull() );
    }
    catch ( std::runtime_error const & e ) {
        m_ok = false;
        m_error = e.what();
    }
}

QWidget * DBusInterface::widget( QWidget * parent ) const {
    QScrollView * scrollview = new QScrollView( parent );
    QVBox * vbox = new QVBox( scrollview->viewport() );
    scrollview->addChild( vbox );
    scrollview->setMidLineWidth( 0 );
    scrollview->setLineWidth( 0 );
    scrollview->setResizePolicy( QScrollView::AutoOneFit );

    new QLabel(
      i18n( "Interface: %1" ).arg( m_interface ),
      vbox
    );

    new QLabel(
      i18n( "Object: %1" ).arg( m_object ),
      vbox
    );

    new QLabel(
      i18n( "Service: %1" ).arg( m_service ),
      vbox
    );

    addAnnotationInfo( vbox );
    addErrorInfo( vbox );

    return scrollview;
}


