/***************************************************************************
                         kscriptedit.h  - script
                         -------------------
    begin                : Thu Aug 28 2003
    copyright            : (C) 2003 by Claudiu Costin
    email                : claudiuc@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __KSCRIPTEDIT_H__
#define __KSCRIPTEDIT_H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kdialogbase.h>

#include "scriptpref.h"
#include "scripttemplate.h"
#include "scriptedit.h"


class KScriptEdit : public KDialogBase
{
  Q_OBJECT

public:
  KScriptEdit(QWidget *parent=0, char *name=0, bool modal=false);
  void setData(ScriptPref p);
  void setInfo(const QString &s);

signals:
  void setPref(ScriptPref data);

protected slots:
  virtual void slotOk();
  virtual void slotApply();
  void slotChanged();
  bool getData();

private:
  ScriptEdit *scriptEdit;
  bool configChanged;
  int outputfilemode;
  QString id, templateid;
  ScriptPref::RunMode runmode;
};


#endif
