/***************************************************************************
                          ftpsession.cpp  -  pure-ftpd FTP session data
                             -------------------
    begin                : Wed Feb 6 2002
    copyright            : (C) 2002 by Claudiu Costin
    email                : claudiuc@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ftpsession.h"

FTPSessionItem::FTPSessionItem(): _percentage(0), _pid(0), _state(Unknown), _time(0),
								_bandwidth(0),
	              _resume(0), _current_size(0), _total_size(0),
	              _account(QString::null),
	              _file(QString::null), _host(QString::null),
	              _localhost(QString::null), _port(QString::null)
{
}

FTPSessionItem::FTPSessionItem(const FTPSessionItem& item):
                _percentage(item._percentage), _pid(item._pid), _state(item._state), _time(item._time),
								_bandwidth(item._bandwidth),
							  _resume(item._resume), _current_size(item._current_size),
							  _total_size(item._total_size),
                _account(item._account),
                _file(item._file), _host(item._host), _localhost(item._localhost),
                _port(item._port)
{
}

FTPSessionItem::FTPSessionItem(int percentage, pid_t pid, Status state, unsigned long time,
											 unsigned long bandwidth,
							 				 unsigned long long resume, unsigned long long current_size,
							 				 unsigned long long total_size,
                       const QString &account,
                       const QString &file, const QString &host,
                       const QString &localhost, const QString &port) :
                _percentage(percentage), _pid(pid), _state(state), _time(time),
								_bandwidth(bandwidth),
							  _resume(resume), _current_size(current_size),
							  _total_size(total_size),
                _account(account),
                _file(file), _host(host), _localhost(localhost),
                _port(port)
{
}

FTPSessionItem::~FTPSessionItem(){
}

