/***************************************************************************
 *   Copyright (C) 2005 by Christian Weilbach   *
 *   christian_weilbach@web.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "kbloggerconfigdialog.h"
#include "kbloggerconfig.h"
#include <klineedit.h>
#include <kcombobox.h>
#include <kdebug.h>
#include <qlabel.h>

#include "API_Blog.h"
#include "API_Blogger.h"

KBloggerConfigDialog::KBloggerConfigDialog(QWidget* parent, const char* name, WFlags fl)
        : KBloggerConfigBlank(parent,name,fl)
{
	updateBlogIds();
	connect(kcfg_Url, SIGNAL( lostFocus() ),
			this, SLOT( updateBlogIds() ) );
	connect(kcfg_User, SIGNAL( lostFocus() ),
			this, SLOT( updateBlogIds() ) );
	connect(kcfg_Password, SIGNAL( lostFocus() ),
			this, SLOT( updateBlogIds() ) );
	connect(kcfg_Type, SIGNAL( activated( int ) ),
			this, SLOT( setUrl( int ) ) );
	connect(kcfg_BlogId, SIGNAL( activated( int ) ),
			this, SLOT( setBlogName( int ) ) );
}

KBloggerConfigDialog::~KBloggerConfigDialog()
{}

void KBloggerConfigDialog::addBlogId( const QString& id, const QString& name ){
	kcfg_BlogId->insertItem( id );
	blogNames.append( name );
}

void KBloggerConfigDialog::setBlogName( int id ){
	kdDebug() << "blogNames[ " << id << "] = " << blogNames[id] << endl;
	BlogNameShowLabel->setText( blogNames[ id ] );
}

void KBloggerConfigDialog::setUrl( int index ){
	if( ( kcfg_Url->text() ).isEmpty() && index==0 ) kcfg_Url->setText( "http://www.blogger.com/api/RPC2" );
}

void KBloggerConfigDialog::updateBlogIds(){

	if( !( kcfg_Url->text() ).isEmpty() && !( kcfg_User->text() ).isEmpty() && !( kcfg_Password->text() ).isEmpty() ){
	// FIXME assuming that Blogger API is available, if it's not we get a fault, which is not handled
		kcfg_BlogId->clear();
		kdDebug() << "Creating APIBlogger( '"<< kcfg_Url->text() << "' )" << endl;
		backend = new KBlog::APIBlogger(  kcfg_Url->text() ); 
		backend->setAppID( "0123456789ABCDEF" ); // id not needed anymore
		backend->setUsername( kcfg_User->text() );
		backend->setPassword( kcfg_Password->text() );
		KIO::Job * job = backend->createListFoldersJob();
		connect( job, SIGNAL( result( KIO::Job * ) ),
				backend, SLOT( interpretListFoldersJob( KIO::Job * ) ) );
		connect( backend, SIGNAL( folderInfoRetrieved( const QString &, const QString & ) ),
				this, SLOT( addBlogId( const QString&, const QString& ) ) );
		blogNames = QValueVector<QString>();
	}
}
/*$SPECIALIZATION$*/


#include "kbloggerconfigdialog.moc"

