/***************************************************************************
 *   Copyright (C) 2005 by Christian Weilbach   *
 *   christian_weilbach@web.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef KBLOGGER_H
#define KBLOGGER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kdeversion.h>
#include <kpanelapplet.h>
#include <qstring.h>
#include <qpoint.h>
#include <kconfigdialog.h>
#include <kaboutapplication.h>

#include "API_Blog.h"
#include "kbloggerconfigdialog.h"
#include "kbloggereditor.h"
#include "kbloggerupload.h"
#include "kbloggermenu.h"

// #if KDE_IS_VERSION(3,5,0) 
// #include "kbloggerbutton.h"
// #endif

class KBloggerMenu;
// class KBloggerButton;

class KBlogger : public KPanelApplet
{
	Q_OBJECT
	
public:
	KBlogger(const QString& configFile, Type t = Normal, int actions = 0,
		QWidget *parent = 0, const char *name = 0);

	~KBlogger();
	
	virtual int widthForHeight(int height) const;
	virtual int heightForWidth(int width) const;
	virtual void about();
	virtual void reportBug();
	virtual void help();
	virtual void preferences();

public slots:
	void slotClicked();
	void menuSlot();
	void editorSlot();
	void editorSlot(int);
	void uploadSlot();
	void uploadSlot( QString );

protected:
	void resizeEvent(QResizeEvent *);
	void mousePressEvent(QMouseEvent *);

private:
	KConfigDialog* m_configDialog;
	KBloggerConfigDialog* m_configwd;
	KBlog::APIBlog* m_backend;
	KAboutData* m_aboutData;
	KBloggerMenu* m_menu;
	KBloggerEditor* m_editor;
	KBloggerUpload* m_upload;
// #if KDE_IS_VERSION(3,5,0) 
// 	KBloggerButton* m_button;
// #else
	QPushButton* m_button;
// #endif

private slots:
	void updateBackend();
	void handleSuccess( const QString& );
	void handleBackendError( const QString& );
};

#endif
