/***************************************************************************

   Copyright (C) 2005-2007 by Christian Weilbach <christian_weilbach@web.de>
   Copyright (C) 2007 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#ifndef UPLOAD_MEDIA_DIALOG_H
#define UPLOAD_MEDIA_DIALOG_H

#include <QDir>
#include <QDialog>
#include <QString>
#include <QByteArray>

#include "ui_uploadmediadialogbase.h"

namespace KIO
{
class StoredTransferJob;
};
class KJob;

namespace KBlogger
{

class KBloggerImageManager;
class KBloggerMedia;
class BlogChooser;

class UploadMediaDialog: public QDialog, public Ui::UploadMediaDialogBase
{
    Q_OBJECT
public:
    explicit UploadMediaDialog( const QString& filename = QString(),
                       const QString& blogname = QString(),
                       QWidget *parent = 0);
    virtual ~UploadMediaDialog();

private Q_SLOTS:
    void enqueueSlot();
    void handleFileJobResult( KJob* );
    void updateServersideName(const QString& filename);
    void updateFilesize(const QString& filename);

private:
    KBloggerMedia* mMedia;
    KBloggerMedia* mThumbnail;
    QString mBlogname;
    KIO::StoredTransferJob *fileJob;
    BlogChooser *mBlogChooser;
    KBloggerImageManager *mImageManager;
};
}
#endif
