/***************************************************************************

   Copyright (C) 2005-2007 by Christian Weilbach <christian_weilbach@web.de>
   Copyright (C) 2007 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#ifndef PROFILE_CONFIG_DIALOG_H
#define PROFILE_CONFIG_DIALOG_H

#include "ui_profileconfigdialogbase.h"

#include "backend.h"
#include "profileconfig.h"
#include <kblog/blog.h>

class QTimer;
class KConfigDialog;

namespace KIO
{
    class Job;
}
class KJob;


namespace KWallet
{
    class Wallet;
}

namespace KBlogger
{

class ProfileConfigDialog : public QWidget, public Ui::ProfileConfigDialogBase
{
    Q_OBJECT

public:
    ProfileConfigDialog(KConfigDialog* parent);
    virtual ~ProfileConfigDialog();

    void readPasswordFromWallet();

private Q_SLOTS:
    void savePasswordToWallet();
    void enableFetchBlogId();
    void autoconfigure();
    void proposeUrl( int );
    void fetchBlogId();
    void fetchedBlogId( const QList<QMap<QString, QString> >& );
    void fetchedProfileId( const QString& );
    void handleFetchError( KBlog::Blog::ErrorType, const QString& );
    void handleFetchIDTimeout();
    void handleFetchAPITimeout();

    void gotHtml(KJob *);
    void gotXmlRpcTest(KJob *);

private:
    KWallet::Wallet* mWallet;
    KConfigDialog* parent;
    KBlog::Blog* mBlog;
    QTimer* mFetchProfileIdTimer;
    QTimer* mFetchAPITimer;
    KIO::Job *httpGetJob;
    KIO::Job *testXmlRpcJob;
};
}
#endif

