/***************************************************************************

   Copyright (C) 2007 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#include "kbloggerapplication.h"
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

using namespace KBlogger;
static const char description[] =
    I18N_NOOP("KDE Blog Manager");

static const char version[] = "1.0-alpha2";

int main(int argc, char **argv)
{
    KAboutData about("kblogger", 0, ki18n("KBlogger"), version, ki18n(description),
                     KAboutData::License_GPL, ki18n("(C) 2005-2008 The KBlogger developers"), KLocalizedString(), 0, "gnuton@gnuton.org");

    about.addAuthor( ki18n("Antonio Aloisio"),
                     ki18n("Maintainer, Core Developer"),
                     "gnuton@gnuton.org" );

    about.addAuthor( ki18n("Christian Weilbach"),
                     ki18n("Original Author, KBlog API Author, Developer"),
                     "christian_weilbach@web.de" );

    about.addCredit( ki18n("Kenneth Wimer"),
                     ki18n ( "Icon designer" ),
                     "kwwii@bootsplash.org" );

    KCmdLineArgs::init(argc, argv, &about);

    KCmdLineOptions options;
    options.add("+[URL]", ki18n( "Document to blog" ));
    KCmdLineArgs::addCmdLineOptions(options);

    KBloggerApplication kblogger;

    /*
    // see if we are starting with session management
    if (app.isSessionRestored()) {
        RESTORE( kblogger );
    } else {
        // no session.. just start up normally
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
        if (args->count() == 0) {
            //kblogger *widget = new kblogger;
            widget->show();
        } else {
            int i = 0;
            for (; i < args->count(); i++) {
                //kblogger *widget = new kblogger;
                widget->show();
            }
        }
        args->clear();
    }*/

    return kblogger.exec();
}
